<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'public/inc/OEM_Language.php';
require_once OEM_PLUGIN_DIR_PATH . 'public/inc/OEM_Shortcode.php';
require_once OEM_PLUGIN_DIR_PATH . 'public/inc/OEM_P_Exam.php';
require_once OEM_PLUGIN_DIR_PATH . 'public/inc/OEM_P_Result.php';
require_once OEM_PLUGIN_DIR_PATH . 'public/inc/OEM_P_Student.php';
require_once OEM_PLUGIN_DIR_PATH . 'public/inc/OEM_P_Payment.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Schedule.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';
add_filter('doing_it_wrong_trigger_error', function () {return false;}, 10, 0);

add_action( 'plugins_loaded', array( 'OEM_Language', 'load_translation' ) );

add_shortcode( 'online_exam', array( 'OEM_Shortcode', 'online_exam' ) );
add_shortcode( 'online_exam_results', array( 'OEM_Shortcode', 'online_exam_results' ) );
add_shortcode( 'online_exam_all_results', array( 'OEM_Shortcode', 'online_exam_all_results' ) );
add_shortcode( 'online_exam_registration', array( 'OEM_Shortcode', 'online_exam_registration' ) );

// Load exam instructions.
add_action( 'wp_ajax_oem-p-load-exam-instructions', array( 'OEM_P_Exam', 'load_exam_instructions' ) );

// Load question.
add_action( 'wp_ajax_oem-p-load-question', array( 'OEM_P_Exam', 'load_question' ) );

// Load exam results.
add_action( 'wp_ajax_nopriv_oem-p-load-exam-results', array( 'OEM_P_Result', 'load_exam_results' ) );
add_action( 'wp_ajax_oem-p-load-exam-results', array( 'OEM_P_Result', 'load_exam_results' ) );

//Download past exam key 
add_action( 'wp_ajax_nopriv_oem-p-download-exam-key', array( 'OEM_P_Result', 'download_exam_key' ) );
add_action( 'wp_ajax_oem-p-download-exam-key', array( 'OEM_P_Result', 'download_exam_key' ) );


add_action( 'wp_ajax_oem-p-photo', array( 'OEM_P_Result', 'save_photo' ) );

// Registration.
add_action( 'wp_ajax_nopriv_oem-p-register', array( 'OEM_P_Student', 'register' ) );

// Payment.
add_action( 'wp_ajax_oem-p-payment', array( 'OEM_P_Payment', 'payment' ) );

// notification
add_action( 'oem_notify_for_student_admission', array( 'OEM_Schedule', 'notify_for_student_registration' ), 10, 4 );
add_action( 'oem_notify_for_student_result', array( 'OEM_Schedule', 'notify_for_student_exam_result' ), 10, 4 );

// Process Razorpay.
add_action( 'wp_ajax_oem-razorpay-handler', array( 'OEM_P_Payment', 'razorpay_handler' ) );
add_action( 'wp_ajax_oem-stripe-handler', array( 'OEM_P_Payment', 'stripe_handler' ) );
add_action( 'wp_ajax_nopriv_oem-stripe-handler', array( 'OEM_P_Payment', 'stripe_handler' ) );
