<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Record.php';

global $wp;
?>
<div class="oem">
<?php
$current_page_url = home_url( add_query_arg( array(), $wp->request ) );

if ( is_user_logged_in() ) {
	$record_id = get_current_user_id();

	$record = OEM_M_Record::find( $record_id );

	$logout_url = wp_logout_url( $current_page_url );
	?>
	<div class="oem-logged-in-info">
		<span class="oem-logged-in-text"><?php esc_html_e( 'You are logged in.', 'online-exam-management' ); ?></span>
		<a class="oem-logout-link oem-text-danger" href="<?php echo esc_url( $logout_url ); ?>">
			<?php esc_html_e( 'Logout', 'online-exam-management' ); ?>
		</a>
	</div>
	<?php
	if ( $record ) {
		?>
		<div class="oem-registration-info">
			<span class="oem-d-block oem-mt-1">
				<?php
				echo wp_kses(
					sprintf(
						/* translators: 1: student name, 2: registration number */
						__( 'Welcome, <span class="oem-font-bold">%1$s</span>. Your Registration Number is: <span class="oem-font-bold">%2$s</span>', 'online-exam-management' ),
						esc_html( OEM_Helper::stripslashes( $record->oem_name ) ),
						esc_html( $record->oem_reg_number )
					),
					array(
						'span' => array( 'class' => array() ),
					)
				);
				?>
			</span>
		</div>
		<?php
		require_once OEM_PLUGIN_DIR_PATH . 'public/inc/registration/dashboard/route.php';
	} else {
		require_once OEM_PLUGIN_DIR_PATH . 'public/inc/registration/no_record.php';
	}

} else {
	require_once OEM_PLUGIN_DIR_PATH . 'public/inc/registration/forms/index.php';
}
?>
</div>
<?php
