<?php
defined( 'ABSPATH' ) || die();
$genders = array(
	'male'   => 'Male',
	'female' => 'Female',
	'other'  => 'Other',
)
?>
<div class="oem-container">
	<div class="oem-w-md-60">
		<div class="oem-register-box">
			<div class="oem-font-large oem-mb-2"><?php esc_html_e( "Register if you don't have an account", 'online-exam-management' ); ?></div>
			<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-p-register-form">

				<input type="hidden" name="oem_nonce" value="<?php echo esc_attr( wp_create_nonce( 'oem_nonce' ) ); ?>">
				<input type="hidden" name="action" value="oem-p-register">
				<div class="oem">

					<div class="oem-w-md-50">
						<div class="oem-form-group">
							<label for="oem_name" class="oem-font-bold">
								<span class="oem-text-danger">*</span> <?php esc_html_e( 'Student Name', 'online-exam-management' ); ?>:
							</label>
							<br>
							<input type="text" name="name" class="oem-form-control" id="oem_name" placeholder="<?php esc_attr_e( 'Enter your name', 'online-exam-management' ); ?>">
						</div>
					</div>

					<div class="oem-w-md-50">
						<div class="oem-form-group">
							<label for="oem_phone" class="oem-font-bold">
								<span class="oem-text-danger">*</span><?php esc_html_e( 'Phone Number', 'online-exam-management' ); ?>:
							</label>
							<br>
							<input type="text" name="phone" class="oem-form-control" id="oem_phone" placeholder="<?php esc_attr_e( 'Enter phone number', 'online-exam-management' ); ?>">
						</div>
					</div>

					<div class="oem-w-md-50">
						<div class="oem-form-group">
							<label for="oem_father_name" class="oem-font-bold">
								<?php esc_html_e( "Father's Name", 'online-exam-management' ); ?>:
							</label>
							<br>
							<input type="text" name="father_name" class="oem-form-control" id="oem_father_name" placeholder="<?php esc_attr_e( "Enter father's name", 'online-exam-management' ); ?>">
						</div>
					</div>

					<!-- <div class="oem-w-md-50">
					<div class="oem-form-group">
						<label for="oem_father_phone" class="oem-font-bold">
							<?php esc_html_e( "Father's Phone", 'online-exam-management' ); ?>:
						</label>
						<br>
						<input type="text" name="father_phone" class="oem-form-control" id="oem_father_phone" placeholder="<?php esc_attr_e( "Enter father's phone", 'online-exam-management' ); ?>">
					</div>
				</div> -->

					<div class="oem-w-md-50">
						<div class="oem-form-group">
							<label for="oem_dob" class="oem-font-bold">
								<?php esc_html_e( 'Date Of Birth', 'online-exam-management' ); ?>:
							</label>
							<br>
							<input type="text" name="dob" class="oem-form-control oem_date" id="oem_dob" placeholder="<?php esc_attr_e( 'Enter DOB', 'online-exam-management' ); ?>">
						</div>
					</div>

					<div class="oem-w-md-50">
						<div class="oem-form-group">
							<label for="oem_gender" class="oem-font-bold">
								<?php esc_html_e( 'Gender', 'online-exam-management' ); ?>:
							</label>
							<br>
							<select name="gender" class="form-control selectpicker" id="oem_gender" data-live-search="true" title="<?php esc_attr_e( 'gender', 'online-exam-management' ); ?>">
								<?php foreach ( $genders as $key => $value ) { ?>
									<option value="<?php echo esc_attr( $key ); ?>" <?php selected( isset( $gender ), $key, true ); ?>>
										<?php echo esc_html( $value ); ?>
									</option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="oem-form-group">
						<label for="oem_id_number" class="oem-font-bold">
							<?php esc_html_e( 'Identity Number', 'online-exam-management' ); ?>:
						</label>
						<br>
						<input type="text" name="id_number" class="oem-form-control" id="oem_id_number" placeholder="<?php esc_attr_e( 'Enter Number', 'online-exam-management' ); ?>">
					</div>
<br>

					<div class="oem-form-group">
						<label for="oem_address" class="oem-font-bold">
							<?php esc_html_e( 'Address', 'online-exam-management' ); ?>:
						</label>
						<br>
						<textarea name="address" id="oem_address" cols="30" rows="3" placeholder="<?php esc_attr_e( 'Enter address', 'online-exam-management' ); ?>"></textarea>
					</div>

					<div class="oem-form-group">
						<label for="oem_photo" class="oem-font-bold">
							<?php esc_html_e( 'Upload Photo', 'online-exam-management' ); ?>:
						</label>
						<br>
						<div class="custom-file oem-mb-2">
							<input type="file" class="custom-file-input" id="oem_photo" name="photo">
							<br>
							<small class="oem-text-small oem-text-muted"><?php esc_html_e( 'Recommended Photo Size: 250 x 320.', 'online-exam-management' ); ?></small>
						</div>
					</div>

					<div class="oem-form-group">
						<label for="oem_login_email" class="oem-font-bold">
							<span class="oem-text-danger">*</span> <?php esc_html_e( 'Login Email', 'online-exam-management' ); ?>:
						</label>
						<br>
						<input type="email" name="login_email" class="oem-form-control" id="oem_login_email" placeholder="<?php esc_attr_e( 'Enter login email', 'online-exam-management' ); ?>">
					</div>

					<div class="oem-w-md-50">
						<div class="oem-form-group">
							<label for="oem_username" class="oem-font-bold">
								<span class="oem-text-danger">*</span> <?php esc_html_e( 'Username', 'online-exam-management' ); ?>:
							</label>
							<br>
							<input type="text" name="username" class="oem-form-control" id="oem_username" placeholder="<?php esc_attr_e( 'Enter username', 'online-exam-management' ); ?>">
						</div>
					</div>

					<div class="oem-w-md-50">
						<div class="oem-form-group">
							<label for="oem_password" class="oem-font-bold">
								<span class="oem-text-danger">*</span> <?php esc_html_e( 'Password', 'online-exam-management' ); ?>:
							</label>
							<br>
							<input type="password" name="password" class="oem-form-control" id="oem_password" placeholder="<?php esc_attr_e( 'Enter password', 'online-exam-management' ); ?>">
						</div>
					</div>
				</div>

				<div class="oem-border-top oem-pt-2 oem-mt-1">
					<button class="button oem-btn btn btn-primary" type="submit" id="oem-p-register-btn">
						<?php esc_html_e( 'Register & Proceed to Next Step', 'online-exam-management' ); ?>
					</button>
				</div>
			</form>
		</div>
	</div>

	<div class="oem-w-md-40">
		<div class="oem-login-box">
			<div class="oem-font-large oem-mb-2"><?php esc_html_e( 'Login if you already have an account', 'online-exam-management' ); ?></div>
			<?php
			$login_form_args = array(
				'form_id'        => 'oem-login-form',
				'id_username'    => 'oem-login-username',
				'id_password'    => 'oem-login-password',
				'id_remember'    => 'oem-login-remember',
				'id_submit'      => 'oem-login-submit',
				'value_username' => '',
			);
			wp_login_form( $login_form_args );
			?>
		</div>
	</div>
</div>
