<?php
defined( 'ABSPATH' ) || die();

$currency = OEM_Helper::currency();

// Razorpay settings.
$razorpay        = OEM_Helper::razorpay();
$razorpay_enable = $razorpay['enable'];

// Stripe settings.
$stripe        = OEM_Helper::stripe();
$stripe_enable = $stripe['enable'];

$exams_for_payment = OEM_M_Record::get_upcoming_exams_for_payment();

$upcoming_exams = OEM_M_Record::get_upcoming_exams( $record_id );

$exam_page_url = OEM_Helper::online_exam_page_url();

$record_exams_id = OEM_M_Record::get_record_students_exams_id( $record_id );

$payment_methods_count = 0;
?>

<?php if ( count( $exams_for_payment ) ) { ?>
<div class="oem-menu-page-title">
	<span><?php esc_html_e( 'Register for Upcoming Exams', 'online-exam-management' ); ?></span>
</div>
<div class="oem-menu-page-content">
	<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-p-payment-form">

		<input type="hidden" name="oem_nonce" value="<?php echo esc_attr( wp_create_nonce( 'oem_nonce' ) ); ?>">
		<input type="hidden" name="action" value="oem-p-payment">
		<input type="hidden" name="current_page_url" value="<?php echo esc_url( $current_page_url ); ?>">

		<div class="oem-form-group oem-mb-2">
			<label for="oem_exam" class="oem-font-bold">
				<span class="oem-text-danger">*</span> <?php esc_html_e( 'Select Exams (use Ctrl to select multiple exams)', 'online-exam-management' ); ?>:
			</label>
			<br>
			<select multiple name="exams[]" class="oem-form-control oem_select_exams" id="oem_exams">
			<?php
			$paid_exam_exists = false;
			$free_exam_exists = false;
			foreach ( $exams_for_payment as $exam ) {
				if ( ! in_array( $exam->ID, [$record_exams_id] ) ) {
					$exam_fee = OEM_Helper::sanitize_money( $exam->exam_fee );
					if ( $exam_fee > 0 ) {
						$paid_exam_exists = true;
					} else {
						$free_exam_exists = true;
					}
				?>
				<option value="<?php echo esc_attr( $exam->ID ); ?>" data-free-exam="<?php echo esc_attr( ( $exam_fee > 0 ) ? 0 : 1 ); ?>">
					<?php
					printf(
						/* translators: 1: exam title, 2: exam code, 3: date and time, 4: number of minutes, 5: exam fee */
						esc_html_x( '%1$s (%2$s) (%3$s - %4$s minutes) - Fee: %5$s', 'Exam title and code', 'online-exam-management' ),
						esc_html( OEM_Helper::stripslashes( $exam->exam_title ) ),
						esc_html( $exam->exam_code ),
						esc_html( OEM_Helper::get_at_text( $exam->exam_at ) ),
						esc_html( $exam->duration ),
						esc_html( OEM_Helper::get_money_text( $exam->exam_fee ) )
					);
					?>
				</option>
				<?php
				}
			}
			?>
			</select>
		</div>

		<div class="oem-payment-actions">
			<?php if ( $paid_exam_exists ) { ?>
			<div class="oem-form-group oem-mb-2 oem-payment-methods">
				<label for="oem_exam" class="oem-font-bold oem-d-block oem-mb-2">
					<span class="oem-text-danger">*</span> <?php esc_html_e( 'Payment Method', 'online-exam-management' ); ?>:
				</label>

				<?php
				if ( $razorpay_enable && OEM_Helper::currency_supports_razorpay( $currency ) ) { ?>
					<label class="radio-inline oem-mr-3">
						<input type="radio" name="payment_method" class="oem-mr-1" value="razorpay" id="oem-payment-razorpay">
						<?php echo esc_html( OEM_Helper::get_payment_method_text( 'razorpay' ) ); ?>
					</label>
					<?php
					$payment_methods_count++;
				}
				if ( $stripe_enable && OEM_Helper::currency_supports_stripe( $currency ) ) {
					?>
					<label class="radio-inline oem-mr-3">
						<input type="radio" name="payment_method" class="oem-mr-1" value="stripe" id="oem-payment-stripe">
						<?php echo esc_html( OEM_Helper::get_payment_method_text( 'stripe' ) ); ?>
					</label>
					<?php
					$payment_methods_count++;
				}
				?>

				<?php if( $payment_methods_count < 1 ) { ?>
				<div class="oem-border-top oem-pt-2 oem-mt-2">
					<span class="oem-text-danger oem-font-bold"><?php esc_html_e( 'No payment method available right now.', 'online-exam-management' ); ?></span>
				</div>
				<?php } ?>
			</div>
			<?php } ?>

			<div class="oem-border-top oem-pt-2 oem-mt-1">
				<button class="button oem-btn btn btn-primary" type="submit" id="oem-p-payment-btn" data-register="<?php esc_attr_e( 'Register', 'online-exam-management' ); ?>" data-proceed-to-pay="<?php esc_attr_e( 'Proceed to Pay', 'online-exam-management' ); ?>" data-payment-methods-available="<?php echo esc_attr( ( $payment_methods_count < 1 ) ? 0 : 1 ); ?>">
					<?php
					if ( $free_exam_exists ) {
						esc_html_e( 'Register', 'online-exam-management' );
					} else {
						esc_html_e( 'Proceed to Pay', 'online-exam-management' );
					}
					?>
				</button>
			</div>
		</div>

	</form>

	<div class="oem-payment-response"></div>
</div>
<?php } ?>

<div class="oem-menu-page-title">
	<span><?php esc_html_e( 'Your Upcoming Exams', 'online-exam-management' ); ?></span>
</div>

<div class="oem-menu-page-content">
	<?php
	if ( count( $upcoming_exams ) ) {
		foreach ( $upcoming_exams as $row ) {
		?>
	<ul class="oem-list oem-list-exam">
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Title:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( OEM_Helper::stripslashes( $row->exam_title ) ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Code:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( $row->exam_code ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Date and Time:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( OEM_Helper::get_at_text( $row->exam_at ) ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Duration (in minutes):', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo absint( $row->duration ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Roll Number:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( OEM_Helper::get_text( $row->roll_number ) ); ?>
			</span>
		</li>
		<?php if ( $row->user_id ) { ?>
		<li>
			<a target="_blank" href="<?php echo esc_url( $exam_page_url.'?id='.$row->ID. ''); ?>">
				<?php esc_html_e( 'Visit Online Exam Portal', 'online-exam-management' ); ?>
			</a>
		</li>
		<?php } ?>
	</ul>
		<?php
		}
	} else {
	?>
	<div class="oem-text-danger">
		<?php esc_html_e( 'No upcoming exam found.', 'online-exam-management' ); ?>
	</div>
	<?php
	}
	?>
</div>