<?php
defined( 'ABSPATH' ) || die();

$exam = OEM_M_Exam::fetch_exam( $student->exam_id );
if ( ! $exam ) {
	die;
}

$exam_title                = $exam->exam_title;
$exam_code                 = $exam->exam_code;
$exam_center               = $exam->exam_center;
$exam_at                   = $exam->exam_at;
$duration                  = $exam->duration;
$instructions              = $exam->instructions;
$show_result_on_completion = $exam->show_result_on_completion;

$exam_status = OEM_Helper::get_exam_status_text( $exam_at, $duration, true, true );
?>
<div class="oem-exam-status oem-row">
	<div class="oem-student-exam-detail oem-col-md-9">
		<ul class="oem-list oem-content-padding">
			<li>
				<span class="oem-list-item-key oem-font-bold"><?php esc_html_e( 'Student Name:', 'online-exam-management' ); ?></span>
				<span class="oem-list-item-value">
					<?php echo esc_html( OEM_Helper::stripslashes( $student->name ) ); ?>
				</span>
			</li>
			<li>
				<span class="oem-list-item-key oem-font-bold"><?php esc_html_e( 'Roll Number:', 'online-exam-management' ); ?></span>
				<span class="oem-list-item-value">
					<?php echo esc_html( OEM_Helper::get_text( $student->roll_number ) ); ?>
				</span>
			</li>
			<li>
				<span class="oem-list-item-key oem-font-bold"><?php esc_html_e( 'Exam:', 'online-exam-management' ); ?></span>
				<span class="oem-list-item-value">
				<?php
					printf(
						wp_kses(
							/* translators: 1: exam title, 2: exam code, 3: date and time, 4: number of minutes */
							__( '%1$s (%2$s) (%3$s - %4$s minutes)', 'online-exam-management' ),
							array(
								'span' => array( 'class' => array() )
							)
						),
						esc_html( OEM_Helper::stripslashes( $exam_title ) ),
						esc_html( $exam_code ),
						esc_html( OEM_Helper::get_at_text( $exam_at ) ),
						esc_html( $duration )
					);
				?>
				</span>
			</li>
			<li>
				<span class="oem-list-item-key oem-font-bold"><?php esc_html_e( 'Status:', 'online-exam-management' ); ?></span>
				<span class="oem-list-item-value">
					<?php
					echo wp_kses(
						$exam_status['text'],
						array( 'span' => array( 'class' => array() ) )
					);

					if ( 'active' === $exam_status['key'] ) {
						if ( $exam->is_activated ) {
							require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/continue_exam.php';
						?>
						<div class="oem-continue-exam-redirect oem-mt-1">
							<em><?php esc_html_e( 'Redirecting to exam window...', 'online-exam-management' ); ?></em>
						</div>
						<?php
						}
					}
					?>
				</span>
			</li>
		</ul>
	</div>

	<?php if ( ! empty ( $student->photo_id ) && ( $photo_url = wp_get_attachment_url( $student->photo_id ) ) ) { ?>
	<div class="oem-student-photo oem-col-md-3 oem-text-center oem-text-md-right">
		<img src="<?php echo esc_url( $photo_url ); ?>" class="img-responsive oem-photo">
	</div>
	<?php } ?>

	<div class="oem-col-md-12">
 		<?php
 		if ( 'pending' === $exam_status['key'] ) {
 			if ( $exam->is_activated ) {
		?>
		<div class="oem-text-center oem-mt-3">
			<a class="oem-btn oem-btn-primary" href="<?php echo esc_url( $exam_window_url ); ?>"><?php esc_html_e( 'Read Instructions', 'online-exam-management' ); ?></a>
		</div>
		<?php
			} else {
			?>
		<div class="oem-mt-3 oem-border-bottom oem-exam-not-activated">
			<span class="oem-text-danger oem-d-i-block oem-mb-2"><?php esc_html_e( 'Exam is not activated yet.', 'online-exam-management' ); ?></span>
		</div>
			<?php
			}
		} elseif ( 'completed' === $exam_status['key'] ) {
			// Check if result to be shown after completion of an exam and subjective result is not incomplete.
			if ( $show_result_on_completion && ! OEM_M_Result::is_subjective_result_incomplete( $student->ID, $exam->ID ) ) {
				require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_result.php';
			}
		}
		?>
	</div>
</div>
<?php
