<?php
defined('ABSPATH') || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';

class OEM_P_Student
{
	public static function register()
	{
		OEM_Helper::check_nonce();

		try {
			ob_start();
			global $wpdb;

			$errors = array();

			// Student detail.
			$name         = isset($_POST['name']) ? sanitize_text_field($_POST['name']) : '';
			$roll_number  = isset($_POST['roll_number']) ? sanitize_text_field($_POST['roll_number']) : '';
			$phone        = isset($_POST['phone']) ? sanitize_text_field($_POST['phone']) : '';
			$address      = isset($_POST['address']) ? sanitize_text_field($_POST['address']) : '';
			$father_name  = isset($_POST['father_name']) ? sanitize_text_field($_POST['father_name']) : '';
			$father_phone = isset($_POST['father_phone']) ? sanitize_text_field($_POST['father_phone']) : '';
			$photo        = (isset($_FILES['photo']) && is_array($_FILES['photo'])) ? $_FILES['photo'] : NULL;
			$dob          = isset( $_POST['dob'] ) ? DateTime::createFromFormat( OEM_Helper::date_format(), sanitize_text_field( $_POST['dob'] ) ) : '';
			$id_number    = isset($_POST['id_number']) ? sanitize_text_field($_POST['id_number']) : '';
			$gender       = isset($_POST['gender']) ? sanitize_text_field($_POST['gender']) : '';

			// Login detail.
			$username          = isset($_POST['username']) ? sanitize_text_field($_POST['username']) : '';
			$login_email       = isset($_POST['login_email']) ? sanitize_text_field($_POST['login_email']) : '';
			$password          = isset($_POST['password']) ? sanitize_text_field( $_POST['password'] ) : '';

			// Student detail.
			if (empty($name)) {
				$errors['name'] = esc_html__('Please enter student name.', 'online-exam-management');
			} elseif (strlen($name) > 60) {
				$errors['name'] = esc_html__('Maximum length cannot exceed 60 characters.', 'online-exam-management');
			}

			if (empty($phone)) {
				$errors['phone'] = esc_html__('Please enter student phone number.', 'online-exam-management');
			} elseif (strlen($phone) > 12) {
				$errors['phone'] = esc_html__('Maximum length cannot exceed 12 characters.', 'online-exam-management');
			}

			if ( !empty( $dob ) ) {
				$dob = $dob->format( 'Y-m-d H:i:s' );
			}

			if (!empty($roll_number) && strlen($roll_number) > 40) {
				$errors['roll_number'] = esc_html__('Maximum length cannot exceed 40 characters.', 'online-exam-management');
			}

			if (!empty($class) && strlen($class) > 191) {
				$errors['class'] = esc_html__('Maximum length cannot exceed 191 characters.', 'online-exam-management');
			}

			if (!empty($section) && strlen($section) > 191) {
				$errors['section'] = esc_html__('Maximum length cannot exceed 191 characters.', 'online-exam-management');
			}

			if (!empty($phone) && strlen($phone) > 40) {
				$errors['phone'] = esc_html__('Maximum length cannot exceed 40 characters.', 'online-exam-management');
			}

			if (!empty($father_name) && strlen($father_name) > 60) {
				$errors['father_name'] = esc_html__('Maximum length cannot exceed 60 characters.', 'online-exam-management');
			}

			if (!empty($father_phone) && strlen($father_phone) > 40) {
				$errors['father_phone'] = esc_html__('Maximum length cannot exceed 40 characters.', 'online-exam-management');
			}

			if (isset($photo['tmp_name']) && !empty($photo['tmp_name'])) {
				if (!OEM_Helper::is_valid_file($photo, 'image')) {
					$errors['photo'] = esc_html__('Please provide photo in JPG, JPEG or PNG format.', 'online-exam-management');
				}
			}

			if (empty($username)) {
				$errors['username'] = esc_html__('Please provide username.', 'online-exam-management');
			}
			if (empty($login_email)) {
				$errors['login_email'] = esc_html__('Please provide login email.', 'online-exam-management');
			}
			if (!filter_var($login_email, FILTER_VALIDATE_EMAIL)) {
				$errors['login_email'] = esc_html__('Please provide a valid email.', 'online-exam-management');
			}
			if (empty($password)) {
				$errors['password'] = esc_html__('Please provide login password.', 'online-exam-management');
			}

			OEM_Helper::check_buffer();
		} catch (Exception $exception) {
			wp_send_json_error($exception->getMessage());
		}

		if (count($errors) > 0) {
			wp_send_json_error($errors);
		}

		try {
			$wpdb->query('BEGIN;');

			// New user.
			$user_data = array(
				'user_email' => $login_email,
				'user_login' => $username,
				'user_pass'  => $password,
			);

			$user_id = wp_insert_user($user_data);
			if (is_wp_error($user_id)) {
				throw new Exception($user_id->get_error_message());
			}

			$reg_number = OEM_Helper::generate_reg_number();

			OEM_M_Record::save(
				$user_id,
				array(
					'reg_number'   => $reg_number,
					'name'         => $name,
					'phone'        => $phone,
					'address'      => $address,
					'father_name'  => $father_name,
					'father_phone' => $father_phone,
					'gender'       => $gender,
					'id_number'    => $id_number,
					'dob'          => $dob,
				)
			);

			if (!empty($photo)) {
				$photo = media_handle_upload('photo', 0);
				if (is_wp_error($photo)) {
					throw new Exception($photo->get_error_message());
				}
				update_user_meta($user_id, 'oem_photo_id', $photo);
			}

			// OEM_Helper::check_buffer();

			$wpdb->query('COMMIT;');

			
			wp_set_current_user($user_id, $username);
			wp_set_auth_cookie($user_id);
			// do_action('wp_login', $username);

			$message = esc_html__('Your registration has been completed. You can now apply for the upcoming exams in your dashboard.', 'online-exam-management');

			wp_send_json_success(array('message' => $message));
		} catch (Exception $exception) {
			wp_send_json_error($exception->getMessage());
		}
	}
}
