<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Exam.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Student.php';

class OEM_P_Result {
	public static function load_exam_results() {
		OEM_Helper::check_nonce();

		$exam_id = isset( $_POST['exam'] ) ? absint( $_POST['exam'] ) : 0;

		try {
			ob_start();
			global $wpdb;

			$errors = array();

			if ( empty( $exam_id ) ) {
				$errors['exam'] = esc_html__( 'Please select an exam.', 'online-exam-management' );
				wp_send_json_error( $errors );
			} else {
				// Checks if exam exists.
				$exam = OEM_M_Exam::get_shortcode_exam( $exam_id );
				if ( ! $exam ) {
					$errors['exam'] = esc_html__( 'Exam not found.', 'online-exam-management' );
					wp_send_json_error( $errors );
				}
			}

			$roll_number = isset( $_POST['roll_number'] ) ? sanitize_text_field( $_POST['roll_number'] ) : '';
			$name        = isset( $_POST['name'] ) ? sanitize_text_field( $_POST['name'] ) : '';

			if ( empty( $name ) || strlen( $name ) < 3 ) {
				$errors['name'] = esc_html__( 'Please specify name.', 'online-exam-management' );
				wp_send_json_error( $errors );
			} else {
				$name_start = $result = substr( $name, 0, 3 );
			}

			if ( empty( $roll_number ) ) {
				$errors['roll_number'] = esc_html__( 'Please provide roll number.', 'online-exam-management' );
			} else {
				// Get student by roll number and start name.
				$student = OEM_M_Student::get_student_by_roll_number_and_start_name( $roll_number, $name_start, $exam_id );
				if ( ! $student ) {
					throw new Exception( esc_html__( 'Student not found.', 'online-exam-management' ) );
				}

				$student_id = $student->ID;

				$student = OEM_M_Student::fetch_student( $student_id, $exam_id );
			}

			OEM_Helper::check_buffer();

		} catch ( Exception $exception ) {
			wp_send_json_error( $exception->getMessage() );
		}

		if ( count( $errors ) > 0 ) {
			wp_send_json_error( $errors );
		}

		try {
			ob_start();

			$from_front = true;

			require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/student_detail.php';
			require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_result.php';

			$data = array(
				'student_id' => $student_id,
				'exam_id'    => $exam_id,
			);

			wp_schedule_single_event(time() + 30, 'oem_notify_for_student_result', $data);

			$html = ob_get_clean();

			wp_send_json_success( array( 'html' => $html ) );
		} catch ( Exception $exception ) {
			wp_send_json_error( $exception->getMessage() );
		}
	}

	public function save_photo() {
		OEM_Helper::check_nonce();

		try {
			ob_start();
			global $wpdb;

		$errors = array();

		$student_id = isset( $_POST['student_id'] ) ? sanitize_text_field( $_POST['student_id'] ) : '';
		$exam_id = isset( $_POST['exam_id'] ) ? sanitize_text_field( $_POST['exam_id'] ) : '';
		$image = isset( $_POST['image'] ) ? ( $_POST['image'] ) : '';
		
		
		$success = $wpdb->query( $wpdb->prepare( "UPDATE ".OEM_STUDENTS." SET exam_photos = %s WHERE exam_id = %d AND user_id = %d", $image, $exam_id, $student_id ) );

	
		
		if ( $success === false ) {
			throw new Exception( esc_html__( 'An unexpected error occurred.','online-exam-management' ) );
		}


		$wpdb->query( 'COMMIT;' );
		wp_send_json_success( array( 'message' => esc_html__( 'Your image is saved successfully.', 'online-exam-management' ) ) );
		
		OEM_Helper::check_buffer();
		}  catch ( Exception $exception ) {
			wp_send_json_error( $exception->getMessage() );
		}
		
		
	}

	public static function download_exam_key() {
		// OEM_Helper::check_nonce();
		
		$exam_id	= isset( $_POST['exam_id'] ) ? absint( $_POST['exam_id'] ) : 0;
		$student_id = isset( $_POST['student_id'] ) ? absint( $_POST['student_id'] ) : 0;
		$record = [];
		$record	= OEM_Helper::get_question_answer_sheet( $student_id, $exam_id );		
		$no_of_rec = count($record);
		$exam_title_result = OEM_Helper::get_exam_title($exam_id);
		// var_dump($exam_title_result);
		$exam_title = $exam_title_result[0]->exam_title;
		$exam_code  = $exam_title_result[0]->exam_code;
		?>
		<div class="oem-answersheet-block" id="oem-answersheet-block">
			<button class="oem-print" id="oem-exam-result-pdf-button" data-title="<?php echo $exam_title; ?>" data-styles ='["<?php echo esc_url( OEM_PLUGIN_URL . 'assets/css/print/answer_sheet.css' ); ?>", "<?php echo esc_url( OEM_PLUGIN_URL . 'assets/css/oem-print.css' ); ?>"]'>
			<?php esc_html_e( 'Print', 'online-exam-management' ); ?>
			</button>
			<h4>
				<?php echo $exam_title; ?>
			</h4>
			<?php
		for( $i = 0; $i< $no_of_rec; $i++ ) {
			$quid = $record[$i]->ID;
			$sno = $i+1;			
			?>
				<div class="oem-answersheet-inner-block">
					
					<?php 
						echo $record[$i]->description;					
						$ques_options = OEM_Helper::get_question_option($exam_id, $quid);						
						?>
						<ol>
						<?php
						$ques_options_no = count($ques_options);
						for($j = 0; $j< $ques_options_no; $j++ ) {
							?>
								<li>
									<?php
									if( $ques_options[$j]->is_correct == 1 ) {
										echo $ques_options[$j]->value . "<span class='is_correct'>correct</span>"; 
									} else {
										echo $ques_options[$j]->value;
									}
									?>
								</li>
							<?php
						}
						?>
						</ol>
						<?php
					?>
				</div>
			<?php
		}
		?>
		</div>
		<?php
		die();
	}
}
