<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Exam.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Student.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Response.php';

class OEM_P_Exam {
	public static function load_question() {
		OEM_Helper::check_nonce();

		try {
			ob_start();
			global $wpdb;

			$student_roll_number = isset( $_POST['student_roll_number'] ) ? sanitize_text_field( $_POST['student_roll_number'] ) : '';
			$student_exam_id = isset( $_POST['student_exam_id'] ) ? sanitize_text_field( $_POST['student_exam_id'] ) : '';
			
			$student = OEM_M_Student::get_logged_in_student_with_exam($student_roll_number, $student_exam_id );
			if ( ! $student ) {
				wp_send_json_error( esc_html__( 'Not enrolled in exam.', 'online-exam-management' ) );
			}
			if ( ! $student[0]->exam_is_activated ) {
				wp_send_json_error( esc_html__( 'Exam is not activated.', 'online-exam-management' ) );
			}

			$student_id = $student[0]->ID;
			$exam_id  = $student_exam_id;
			$exam_at  = $student[0]->exam_at;
			$duration = $student[0]->exam_duration;

			$exam_status = OEM_Helper::get_exam_status_text( $exam_at, $duration, true, true );
			if ( 'completed' === $exam_status['key'] ) {
				wp_send_json_error( esc_html__( 'Exam has been completed.', 'online-exam-management' ) );

			} elseif ( 'pending' === $exam_status['key'] ) {
				wp_send_json_error( esc_html__( 'Exam has not started.', 'online-exam-management' ) );
			}

			// Check if questions need to shown in random order for each student.
			$is_randomized = $student[0]->is_randomized;


			// Current question ID.
			$current_question_id = isset( $_POST['current_question_id'] ) ? absint( $_POST['current_question_id'] ) : 0;

			// Next question index.
			$next_q_index = isset( $_POST['next_q_index'] ) ? absint( $_POST['next_q_index'] ) : 1;

			if ( $next_q_index < 1 ) {
				$next_q_index = 1;
			}

			// Student actions.
			$submit_response   = isset( $_POST['submit_response'] ) ? (bool) ( $_POST['submit_response'] ) : 0;
			$mark_for_review   = isset( $_POST['mark_for_review'] ) ? (bool) ( $_POST['mark_for_review'] ) : 0;
			$unmark_for_review = isset( $_POST['unmark_for_review'] ) ? (bool) ( $_POST['unmark_for_review'] ) : 0;
			$clear_response    = isset( $_POST['clear_response'] ) ? (bool) ( $_POST['clear_response'] ) : 0;

			// Get total number of questions.
			$total_questions = $wpdb->get_var( OEM_M_Question::fetch_query_count( $exam_id ) );

			// Next question.
			// Fetch next question by index.
			$next_question = OEM_M_Question::fetch_question_by_index( $next_q_index, $exam_id, $is_randomized, $student_id );

			if ( ! $next_question ) {
				// If question with specified index is not found, then show the first question.
				$next_q_index  = 1;
				$next_question = OEM_M_Question::fetch_question_by_index( $next_q_index, $exam_id, $is_randomized, $student_id );

				if ( ! $next_question ) {
					wp_send_json_error( esc_html__( 'Question not found.', 'online-exam-management' ) );
				}
			}

			$next_question_id   = $next_question->ID;
			$next_question_type = $next_question->type;

			// Check if question is objective type: obj_single or obj_multi.
			$next_question_is_objective = OEM_Helper::is_objective( $next_question_type );

			// Current question.
			// Fetch current question by ID.
			$question = OEM_M_Question::fetch_question_by_id( $current_question_id, $exam_id );
			if ( $question ) {
				$question_id   = $question->ID;
				$question_type = $question->type;

				// Check if current question is objective type: obj_single or obj_multi.
				$question_is_objective = OEM_Helper::is_objective( $question_type );

				if ( $question_is_objective ) {
					if ( 'obj_single' === $question_type ) {
						// Get single-choice response from student.
						$student_response = isset( $_POST['option'] ) ? absint( $_POST['option'] ) : '';
					} else {
						// Get multi-choice response from student.
						$student_response = ( isset( $_POST['option'] ) && is_array( $_POST['option'] ) ) ? array_map( 'absint', $_POST['option'] ) : array();
					}

				} else {
					// Get subjective response from student.
					$student_response = isset( $_POST['option'] ) ? sanitize_text_field( $_POST['option'] ) : '';
				}
			}

			$wpdb->query( 'BEGIN;' );

			// Save the response of the current question.
			if ( $question ) {
				$now = OEM_Helper::now();

				// Check if student has responded or visited to this question.
				$response = OEM_M_Response::get_response( $question_id, $student_id );
				if ( $response ) {
					$response_id = $response->ID;
				}

				$response_data = array(
					'question_id'  => $question_id,
					'student_id'   => $student_id,
					'value'        => '',
					'is_submitted' => 0
				);

				if ( $clear_response ) {
					// Clear the response of the question.
					if ( $response ) {
						// Delete existing answers for this response.
						$wpdb->delete( OEM_ANSWERS, array( 'response_id' => $response_id ) );

						// Unmark for review.
						$response_data['is_marked'] = 0;

						$response_data['updated_at'] = $now;

						$success = $wpdb->update( OEM_RESPONSES, $response_data, array( 'ID' => $response_id ) );
					}

				} else {
					// Save response of the question.

					// Save the subjective answer for the response.
					if ( ! $question_is_objective ) {
						// If question is subjective.
						if ( '' !== $student_response ) {
							// If student has responded with an answer, then save it along with the response.
							$response_data['value'] = $student_response;
							// Mark the response as submitted.
							$response_data['is_submitted'] = 1;

						} else {
							// Clear the subjective answer.
							$response_data['value'] = '';

							// Mark the response as not submitted.
							$response_data['is_submitted'] = 0;
						}
					}

					// Mark for review or not.
					if ( $mark_for_review ) {
						// If student has marked the question for review.
						$response_data['is_marked'] = 1;
					} elseif ( $unmark_for_review ) {
						// If student has unmarked the question for review.
						$response_data['is_marked'] = 0;
					}

					if ( $response ) {
						// If response exists, then update the response.
						$response_data['updated_at'] = $now;

						$success = $wpdb->update( OEM_RESPONSES, $response_data, array( 'ID' => $response_id ) );

					} else {
						// If response does not exist, then create the response. This will mean that the question has been visited, marked or submitted.
						$response_data['created_at'] = $now;

						$success = $wpdb->insert( OEM_RESPONSES, $response_data );

						$response_id = $wpdb->insert_id;
					}

					// Save the objective answers for the response.
					if ( $question_is_objective ) {
						if ( 'obj_single' === $question_type ) {
							// Single-choice.
							$option_id = $student_response;

							// Check if option belongs to the question.
							$option = OEM_Question::get_option( $option_id, $question_id );

							if ( $option ) {
								$answer_data = array(
									'option_id'   => $option_id,
									'response_id' => $response_id,
									'created_at'  => $now,
								);

								// Delete existing answers for this response.
								$wpdb->delete( OEM_ANSWERS, array( 'response_id' => $response_id ) );

								// Insert answer for this response.
								$success = $wpdb->insert( OEM_ANSWERS, $answer_data );
								if ( $success ) {
									// Mark the response as submitted.
									$response_data['is_submitted'] = 1;
								}
							}

						} else {
							// Multi-choice.
							$option_ids = $student_response;

							if ( count( $option_ids ) ) {
								// Delete existing answers for this response.
								$wpdb->delete( OEM_ANSWERS, array( 'response_id' => $response_id ) );

								// Insert answers of this response.
								foreach ( $option_ids as $option_id ) {
									$option = OEM_Question::get_option( $option_id, $question_id );
									if ( $option ) {
										$answer_data = array(
											'option_id'   => $option_id,
											'response_id' => $response_id,
											'created_at'  => $now,
										);

										// Insert answer for this response.
										$success = $wpdb->insert( OEM_ANSWERS, $answer_data );
										if ( $success ) {
											$response_data['is_submitted'] = 1;
										}
									}
								}
							}
						}

						// Mark the response as submitted or not submitted.
						$success = $wpdb->update( OEM_RESPONSES, $response_data, array( 'ID' => $response_id ) );
					}
				}
			}

			$subjects = OEM_Question::get_subjects( $student_exam_id );
			// HTML of next question with options.
			ob_start();
			?>
			<div class="oem-question-wrapper oem-window-section">

				<!-- Question header for question number and marks. -->
				<input type="hidden" id="oem-current-question" data-question-type="<?php echo esc_attr( $next_question_type ); ?>" value="<?php echo esc_attr( $next_question_id ); ?>">
				<div class="oem-question-header">
					<span> 
						<strong><?php esc_html_e( 'Subjects:','online-exam-management' ); ?>
						[
						<?php  $number = 1; ?>
						<?php foreach ($subjects as $subject): ?>
						<?php echo "$number.".$subject->subject_name."  "; ?>
						<?php $number++; ?>
						<?php endforeach ?> 
						]
					</strong>
				</span><br>	<br>
					<span class="oem-question-number">
						<?php
						printf(
							wp_kses(
								/* translators: %s: Question number. */
								__( '<span class="oem-font-bold">Question No.</span> <span class="oem-font-extra-bold">%s</span>', 'online-exam-management' ),
								array(
									'span' => array( 'class' => array() )
								)
							),
							esc_html( $next_q_index ."  Subject : $next_question->subject_name")
						);
						?>
					</span>
					<span class="oem-question-marks">
						<span class="oem-question-maximum-marks">
							<?php
							printf(
								wp_kses(
									/* translators: %s: Maximum marks. */
									__( '<span class="oem-text-success oem-font-bold">Right marks:</span> <span class="oem-font-extra-bold">%s</span>', 'online-exam-management' ),
									array(
										'span' => array( 'class' => array() )
									)
								),
								esc_html( OEM_Helper::sanitize_marks( $next_question->maximum_marks ) )
							);
							?>
						</span>

						<span class="oem-question-negative-marks">
							<?php
							printf(
								wp_kses(
									/* translators: %s: Negative marks. */
									__( '<span class="oem-text-danger oem-font-bold">Negative marks:</span> <span class="oem-font-extra-bold">%s</span>', 'online-exam-management' ),
									array(
										'span' => array( 'class' => array() )
									)
								),
								esc_html( OEM_Helper::sanitize_marks( $next_question->negative_marks ) )
							);
							?>
						</span>
					</span>
				</div>

				<!-- Question description wrapper. -->
				<div class="oem-question-description">
					<?php echo wp_kses_post( stripcslashes( $next_question->description ) ); ?>
				</div>

				<?php
				$show_unmark_for_review = false;

				// Check if student has responded or visited to this question.
				$next_response = OEM_M_Response::get_response( $next_question_id, $student_id );

				if ( $next_response ) {
					$next_response_id = $next_response->ID;

					$saved_option_ids = OEM_M_Response::fetch_saved_option_ids( $next_response_id );
					$saved_value      = $next_response->value;

					if ( $next_response->is_marked ) {
						$show_unmark_for_review = true;
					}
				} else {
					$saved_option_ids = array();
					$saved_value      = '';
				}

				if ( $next_question_is_objective ) {
					// Get options.
					$options           = OEM_M_Question::get_options( $next_question_id );
					$number_of_options = count( $options );
				?>
				<!-- Question options. -->
				<div class="oem-question-options">
					<?php
					foreach ( $options as $key => $option ) {
						?>
						<span class="oem-option-wrapper">
						<?php
						if ( 'obj_single' === $next_question_type ) {
							// If single-choice, show radio buttons.
							?>
							<label class="oem-option-label oem-option-radio">
								<input <?php checked( in_array( $option->ID, $saved_option_ids ), true, true ); ?> class="oem-response-input" type="radio" name="option" value="<?php echo esc_attr( $option->ID ); ?>">
								<span class="oem-option-value"><?php echo wp_kses_post( $option->value ); ?></span>
							</label>
							<?php
						} else {
							// If multi-choice, show checkboxes.
							?>
							<label class="oem-option-label oem-option-checkbox">
								<input <?php checked( in_array( $option->ID, $saved_option_ids ), true, true ); ?> class="oem-response-input" type="checkbox" name="option[]" value="<?php echo esc_attr( $option->ID ); ?>">
								<span class="oem-option-value"><?php echo wp_kses_post( $option->value ); ?></span>
							</label>
							<?php
						}
						?>
						</span>
						<?php
					}
					?>
				</div>
				<?php
				} else {
					if ( 'subjective' === $next_question_type ) {
						// Show textarea input for subjective question.
						?>
						<span class="oem-subjective-textarea-wrapper">
							<textarea name="option" class="oem-response-input oem-subjective-textarea" cols="30" rows="6"><?php echo esc_html( $saved_value ); ?></textarea>
						</span>
						<?php
					}
				}
				?>
			</div>
			<?php
			// Next question with options.
			$html_question = ob_get_clean();

			ob_start();
			// HTML of nextquestion palette and legend.
			?>
			<div class="oem-question-palette oem-window-section">
				<span class="oem-question-palette-label oem-window-section-label">
					<?php esc_html_e( 'Question Palette', 'online-exam-management' ); ?>
				</span>

				<div class="oem-question-palette-numbers">
					<?php
					// Exam questions and responses by the student.
					$questions = OEM_M_Question::fetch_questions_with_ids( $exam_id, $is_randomized, $student_id );
					$responses = OEM_M_Response::fetch_responses( $student_id, $exam_id );

					for ( $i = 1; $i <= $total_questions; $i++ ) {
						// Student's response to this question: answered, not-answered, marked, answered-marked, not-visited.
						$color = 'not-visited';

						$key = $i - 1;
						if ( isset( $questions[ $key ] ) ) {
							$palette_question    = $questions[ $key ];
							$palette_question_id = $palette_question->ID;

							// If response exists for this question, check if it is submitted or marked for review.
							if ( isset( $responses[ $palette_question_id ] ) ) {
								$response = $responses[ $palette_question_id ];

								if ( $response->is_marked && $response->is_submitted ) {
									$color = 'answered-marked';
								} elseif ( $response->is_marked ) {
									$color = 'marked';
								} elseif ( $response->is_submitted ) {
									$color = 'answered';
								} else {
									$color = 'not-answered';
								}
							}
							if ( $next_question_id === $palette_question_id ) {
								$color .= ' oem-palette-number-active';
							}
						}
					?>
					<span class="oem-question-palette-number oem-color-<?php echo esc_attr( $color ); ?> oem-question-index-btn" data-q-index="<?php echo esc_attr( $i ); ?>">
						<?php echo esc_html( $i ); ?>
					</span>
					<?php
					}
					?>
				</div>
			</div>

			<?php
			// Next question palette.
			$html_question_palette = ob_get_clean();

			OEM_Helper::check_buffer();

			$wpdb->query( 'COMMIT;' );

			$current_q_index = $next_q_index;

			wp_send_json_success(
				array(
					'html_question'            => $html_question, // Question with options.
					'html_question_palette'    => $html_question_palette, // Question palette.
					'current_q_index'          => $current_q_index, // Current question index.
					'total_questions'          => $total_questions, // Total number of questions.
					'show_unmark_for_review'   => $show_unmark_for_review, // Show unmark for review.
				)
			);

		} catch ( Exception $e ) {
			$wpdb->query( 'ROLLBACK;' );
			wp_send_json_error( $exception->getMessage() );
		}
	}

	public static function load_exam_instructions() {
		OEM_Helper::check_nonce();

		try {
			ob_start();
			global $wpdb;

			

			$student_roll_number = isset( $_POST['student_roll_number'] ) ? sanitize_text_field( $_POST['student_roll_number'] ) : '';
			$student_exam_id = isset( $_POST['student_exam_id'] ) ? sanitize_text_field( $_POST['student_exam_id'] ) : '';
			

			$student = OEM_M_Student::get_logged_in_student_with_exam($student_roll_number, $student_exam_id);

			if ( ! $student ) {
				wp_send_json_error( esc_html__( 'Not enrolled in exam.', 'online-exam-management' ) );
			}
			if ( ! $student[0]->exam_is_activated ) {
				wp_send_json_error( esc_html__( 'Exam is not activated.', 'online-exam-management' ) );
			}

			$student_id = $student[0]->ID;

			$exam_id  = $student[0]->exam_id;

			$exam = OEM_M_Exam::fetch_exam_instructions( $exam_id );

			OEM_Helper::check_buffer();

			wp_send_json_success(
				array(
					'exam_instructions' => $exam->instructions,
				)
			);

		} catch ( Exception $e ) {
			$wpdb->query( 'ROLLBACK;' );
			wp_send_json_error( $exception->getMessage() );
		}
	}
}
