<?php
defined( 'ABSPATH' ) || die();
?>
<div class="text-center oem-section-heading-block">
	<span class="oem-section-heading">
		<i class="fas fa-user"></i>
		<?php
		printf(
			wp_kses(
				/* translators: %s: registraion number */
				__( 'Print Registration: <span class="oem-font-light">%s</span>', 'online-exam-management' ),
				array(
					'span' => array( 'class' => array() )
				)
			),
			esc_html( $reg_number )
		);
		?>
	</span>
	<span class="float-right">
		<a href="<?php echo esc_url( $page_url ); ?>" class="btn btn-sm btn-outline-light">
			<i class="fas fa-users"></i>&nbsp;
			<?php echo esc_html( 'View All', 'online-exam-management' ); ?>
		</a>
	</span>
</div>
<!-- Print  button. -->
<div class="mt-3 mb-3 text-center">
	<button type="button" class="btn btn-success" id="oem-print-student-profile-btn" data-styles='["<?php echo esc_url( OEM_PLUGIN_URL . 'assets/css/bootstrap.min.css' ); ?>","<?php echo esc_url( OEM_PLUGIN_URL . 'assets/css/oem-print.css' ); ?>","<?php echo esc_url( OEM_PLUGIN_URL . 'assets/css/print/answer_sheet.css' ); ?>"]' data-title="<?php
	printf(
		/* translators: 1: exam title, 2: exam code */
		esc_attr__( 'Student Profile - %1$s (%2$s)', 'online-exam-management' ),
		esc_html( OEM_Helper::stripslashes( $name ) ),
		esc_html( $reg_number )
	);
	?>"><?php esc_html_e( 'Print Student Profile', 'online-exam-management' ); ?>
	</button>
</div>
<!-- student profile -->
<div id="oem-print-student-profile">
	<div class="oem">
			<div class="row">
				<div class="col-6">
					<ul class="list-group list-group-flush">
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Student Name:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::stripslashes( $name ) ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Registraion Number:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::get_text( $reg_number ) ); ?></span>
						</li><li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Id Number:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::get_text( $id_number ) ); ?></span>
						</li>
						</li><li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Gender:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::get_text( $gender ) ); ?></span>
						</li>
						</li><li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Date of Birth:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::get_date_text( $dob ) ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Phone:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::get_text( $phone ) ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( "Father's Name:", 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::stripslashes( $father_name ) ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( "Address:", 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::get_text( $address ) ); ?></span>
						</li>
					</ul>
				</div>
				<div class="col-6">
					<?php if ( ! empty ( $photo_id ) ) { ?>
						<img src="<?php echo esc_url( wp_get_attachment_url( $photo_id ) ); ?>" width="150" height="200" class="img-responsive oem-photo ml-1">
					<?php } ?>
				</div>
			</div>

		
	</div>
</div>

