<?php
defined( 'ABSPATH' ) || die();
?>
<!-- Print answer sheet container. -->
<div id="oem-print-answer-sheet">
	<div class="oem">
		<div class="oem-hide">

			<div class="row">
				<div class="col-12">
					<div class="oem-print-header">
						<span class="oem-print-title">
							<?php esc_html_e( "Student's Answer Sheet", 'online-exam-management' ); ?>
						</span>
					</div>
				</div>
			</div>

			<div class="row">
				<div class="col-4">
					<ul class="list-group list-group-flush">
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Student Name:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::stripslashes( $name ) ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Roll Number:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::get_text( $roll_number ) ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Class:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::stripslashes( $class ) ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Section:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::stripslashes( $section ) ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Phone:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::get_text( $phone ) ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( "Father's Name:", 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::stripslashes( $father_name ) ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( "Father's Phone:", 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::get_text( $father_phone ) ); ?></span>
						</li>
					</ul>
				</div>
				<div class="col-4">
					<ul class="list-group list-group-flush">
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Total Questions:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( $questions_count ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Maximum Marks:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( $maximum_marks_sum ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Questions Attempted:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( $questions_attempted_count ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Correct Answers:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( $correct_answers_count ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Incorrect Answers:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( $incorrect_answers_count ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Obtained Marks:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( $obtained_marks_sum ); ?></span>
						</li>
						<li class="list-group-item">
							<span class="oem-font-bold"><?php esc_html_e( 'Percentage:', 'online-exam-management' ); ?></span>
							<span><?php echo esc_html( OEM_Helper::get_percentage_text( $maximum_marks_sum, $obtained_marks_sum ) ); ?></span>
						</li>
					</ul>
				</div>
				<div class="col-3 my-auto">
					<?php if ( ! empty ( $photo_id ) ) { ?>
						<img src="<?php echo esc_url( wp_get_attachment_url( $photo_id ) ); ?>" class="img-responsive oem-photo ml-1">
					<?php } ?>
				</div>
			</div>

		</div>

		<?php require OEM_PLUGIN_DIR_PATH . 'includes/partials/answer_sheet.php'; ?>
	</div>
</div>
