<?php
defined( 'ABSPATH' ) || die();

$now = new DateTime( OEM_Helper::now() );

$end_at = new DateTime( $exam_at );

$interval = $end_at->diff( $now->modify( '-2 seconds' ) );
$diff = $end_at->diff( $now);

$end_at = $end_at->format( 'Y-m-d H:i:s' );
$now    = $now->format( 'Y-m-d H:i:s' );

?>
<span class="oem-exam-timer">
	<span class="oem-exam-timer-clock">
		<span class="oem-exam-timer-value oem-exam-timer-days"><?php echo esc_html( $diff->days ); ?></span>
		<span class="oem-exam-timer-unit"><?php esc_html_e( 'Days', 'online-exam-management' ); ?></span>
	</span>
	<span class="oem-exam-timer-clock">
		<span class="oem-exam-timer-value oem-exam-timer-hour"><?php echo esc_html( $interval->format( '%h' ) ); ?></span>
		<span class="oem-exam-timer-unit"><?php esc_html_e( 'Hours', 'online-exam-management' ); ?></span>
	</span>
	<span class="oem-exam-timer-clock">
		<span class="oem-exam-timer-value oem-exam-timer-minute"><?php echo esc_html( $interval->format( '%I' ) ); ?></span>
		<span class="oem-exam-timer-unit"><?php esc_html_e( 'Minutes', 'online-exam-management' ); ?></span>
	</span>
	<span class="oem-exam-timer-clock">
		<span class="oem-exam-timer-value oem-exam-timer-second"><?php echo esc_html( $interval->format( '%S' ) ); ?></span>
		<span class="oem-exam-timer-unit"><?php esc_html_e( 'Seconds', 'online-exam-management' ); ?></span>
	</span>
</span>
<?php
if ( 'oem-public' === $js_handle ) {
	$show_questions = true;
} else {
	$show_questions = false;
}
ob_start();
?>
(function($) {
	'use strict';

	$(document).ready(function() {
		function oemPad(n, width, z) {
			z = z || '0';
			n = n + '';
			return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
		}

		var examTimerHour = $('.oem-exam-timer-hour');
		var examTimerMinute = $('.oem-exam-timer-minute');
		var examTimerSecond = $('.oem-exam-timer-second');
		var countDownDate = new Date('<?php echo esc_attr( $end_at ); ?>').getTime();
		var now = new Date('<?php echo esc_attr( $now ); ?>');

		var oemTimer = setInterval(function() {
			now.setSeconds( now.getSeconds() + 1 );

			var distance = countDownDate - now.getTime();

			if (distance < 1) {
				clearInterval(oemTimer);
				<?php if ( $show_questions ) { ?>
				$('.oem-start-exam-action').html('' +
					'<button id="oem-start-exam-btn" type="button" class="oem-btn oem-btn-primary oem-start-exam-btn">' +
						'<?php echo esc_html( $start_exam_btn_text ); ?>' +
					'</button>' +
					'');
				<?php } else { ?>
				$('.oem-exam-status-text').html('<?php echo OEM_Helper::get_exam_status_html( 'active', OEM_Helper::get_exam_status( 'active' ) ); ?>');
				<?php } ?>
			}

			var days = Math.floor(distance / (1000 * 60 * 60 * 24));
			var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
			var minutes = oemPad(Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60)), 2);
			var seconds = oemPad(Math.floor((distance % (1000 * 60)) / 1000), 2);

			examTimerHour.html(hours);
			examTimerMinute.html(minutes);
			examTimerSecond.html(seconds);

		}, 1000);
	});
})(jQuery);
<?php
$js = ob_get_clean();
wp_add_inline_script( $js_handle, $js );

