<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Question.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Response.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Result.php';

$exam_id    = $exam->ID;
$student_id = $student->ID;

// Total questions in this exam.
$questions_count = OEM_M_Question::get_questions_count( $exam_id );

// Total maximum marks of questions in this exam.
$maximum_marks_sum = OEM_M_Question::get_questions_maximum_marks_sum( $exam_id );

// Passing percentage.
$passing_percentage = OEM_Helper::sanitize_marks( $exam->passing_percentage );

require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_result_stats.php';
?>
<div class="oem-d-flex">
	<div class="oem-col-md-12 oem-result-stats">
		<table class="oem-table oem-result-stats-table">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Total Questions', 'online-exam-management' ); ?></th>
					<th><?php esc_html_e( 'Questions Attempted', 'online-exam-management' ); ?></th>
					<th><?php esc_html_e( 'Correct Answers', 'online-exam-management' ); ?></th>
					<th><?php esc_html_e( 'Incorrect Answers', 'online-exam-management' ); ?></th>
					<th><?php esc_html_e( 'Maximum Marks', 'online-exam-management' ); ?></th>
					<th><?php esc_html_e( 'Obtained Marks', 'online-exam-management' ); ?></th>
					<th><?php esc_html_e( 'Percentage', 'online-exam-management' ); ?></th>
					<?php
					if ( $passing_percentage > 0 ) {
						?>
					<th><?php esc_html_e( 'Status', 'online-exam-management' ); ?></th>
						<?php
					}
					?>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td><?php echo esc_html( $questions_count ); ?></td>
					<td><?php echo esc_html( $questions_attempted_count ); ?></td>
					<td><?php echo esc_html( $correct_answers_count ); ?></td>
					<td><?php echo esc_html( $incorrect_answers_count ); ?></td>
					<td><?php echo esc_html( $maximum_marks_sum ); ?></td>
					<td><?php echo esc_html( $obtained_marks_sum ); ?></td>
					<td><?php echo esc_html( OEM_Helper::get_percentage_text( $maximum_marks_sum, $obtained_marks_sum ) ); ?></td>
					<?php
					if ( $passing_percentage > 0 ) {
						?>
					<td><?php echo OEM_Helper::get_result_status_text( $passing_percentage, OEM_Helper::sanitize_percentage( $maximum_marks_sum, $obtained_marks_sum ) ); ?></td>
						<?php
					}
					?>
				</tr>
			</tbody>
		</table>
	</div>