<?php
defined( 'ABSPATH' ) || die();
?>
<caption>
	<div class="input-group">
		<select name="bulk_action" data-entity="<?php echo esc_attr( $entity ); ?>" class="bulk-action-select bulk-action-select-<?php echo esc_attr( $entity ); ?> form-control">
			<option value=""><?php esc_html_e( 'Select Option', 'online-exam-management' ); ?></option>
			<option value="delete"><?php esc_html_e( 'Delete', 'online-exam-management' ); ?></option>
		</select>
		<button data-nonce="<?php echo esc_attr( wp_create_nonce( 'bulk-action-' . $entity ) ); ?>" data-message-title="<?php esc_attr_e( 'Confirmation!', 'online-exam-management' ); ?>" data-message-content="<?php esc_attr_e( 'Please confirm the action.', 'online-exam-management' ); ?>" data-cancel="<?php esc_attr_e( 'Cancel', 'online-exam-management' ); ?>" data-submit="<?php esc_attr_e( 'Submit', 'online-exam-management' ); ?>" class="btn btn-danger btn-sm bulk-action-btn bulk-action-btn-<?php echo esc_attr( $entity ); ?>" type="button">
			<?php esc_html_e( 'Apply', 'online-exam-management' ); ?>
		</button>
	</div>
</caption>
