
<table class="oem-table oem-result-stats-table">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Subjects', 'online-exam-management' ); ?></th>
					<th><?php esc_html_e( 'Total Questions', 'online-exam-management' ); ?></th>
					<th><?php esc_html_e( 'Questions Attempted', 'online-exam-management' ); ?></th>
					<!-- <th><?php esc_html_e( 'Correct Answers', 'online-exam-management' ); ?></th> -->
					<!-- <th><?php esc_html_e( 'Incorrect Answers', 'online-exam-management' ); ?></th> -->
					<th><?php esc_html_e( 'Maximum Marks', 'online-exam-management' ); ?></th>
					<!-- <th><?php esc_html_e( 'Marks Obtained', 'online-exam-management' ); ?></th> -->
				</tr>
			</thead>
			<?php
	// Total questions in exam subjects\
	foreach ( $subjects as $subject ) {
		$subject_id = $subject->ID;

		$questions_count_in_subject = OEM_M_Question::get_questions_count_subject($student_id, $exam_id, $subject_id );
		$questions_attempted_count = OEM_M_Question::get_questions_count_subject_count($student_id, $exam_id, $subject_id );
		
		// Total questions attempted by the student in this exam.
		$questions_attempted       = OEM_M_Result::get_questions_attempted_subject( $student_id, $exam_id, $subject_id );
		// $questions_attempted_count = count( $questions_attempted );

		// Total maximum marks of questions in this exam.
		$maximum_marks_sum_subject = OEM_M_Question::get_questions_maximum_marks_sum_subject( $exam_id, $subject_id );

		// Correct options.
		$correct_options = OEM_M_Result::get_questions_attempted_correct_options_subject( $student_id, $exam_id, $subject_id );		

		// Student answers.
		$student_answers = OEM_M_Result::get_student_answers_subject( $student_id, $exam_id, $subject_id );

		// Subjective responses.
		$subjective_responses = OEM_M_Result::get_subjective_marks_obtained_subject( $student_id, $exam_id , $subject_id );

		// calculating the questions
		$obtained_marks_sum_subject      = 0;
		$correct_answers_count_subject   = 0;
		$incorrect_answers_count_subject = 0;

		

		foreach ( $questions_attempted as $question ) {
			$questions_maximum_marks  = $question->maximum_marks;
			$questions_negative_marks = $question->negative_marks;

			if ( 'subjective' === $question->type ) {
				// Get subjective obtained marks of this question.
				$student_subjective_response = '';
				foreach ( $subjective_responses as $subjective_response ) {
					if ( $question->ID === $subjective_response->question_id ) {
						$student_subjective_response = $subjective_response;
						break;
					}
				}

				if ( $student_subjective_response ) {
					$student_obtained_marks = OEM_Helper::sanitize_marks( $student_subjective_response->sbj_marks_obtained );
				} else {
					$student_obtained_marks = 0;
				}

				// Add subjective obtained marks if greater than 0.
				if ( $student_obtained_marks > 0 ) {
					$obtained_marks_sum_subject += $student_obtained_marks;
					$correct_answers_count_subject++;
				} else {
					$incorrect_answers_count_subject++;
				}
			} else {
				// Get correct option(s) of this question.
				$question_correct_options = array_filter(
					$correct_options,
					function( $correct_option ) use ( $question ) {
						return $question->ID === $correct_option->question_id;
					}
				);
				// Get correct option_id(s) of this question.
				$question_correct_option_ids = array_map(
					function( $question_correct_option ) {
						return $question_correct_option->ID;
					},
					$question_correct_options
				);

				// Get student answer(s) of this question.
				$question_student_answers = array_filter(
					$student_answers,
					function( $student_answer ) use ( $question ) {
						return $question->ID === $student_answer->question_id;
					}
				);
				// Get student answer(s) option_id(s) of this question.
				$question_student_answers_option_ids = array_map(
					function( $question_student_answer ) {
						return $question_student_answer->option_id;
					},
					$question_student_answers
				);
				
				// Check if two arrays are equal.
				$same = ( count( $question_correct_option_ids ) === count( $question_student_answers_option_ids ) && ! array_diff( $question_correct_option_ids, $question_student_answers_option_ids ) );
				if ( $same ) {
					// Student's answer is correct.
					$obtained_marks_sum_subject += $questions_maximum_marks;
					$correct_answers_count_subject++;
				} else {
					// Student's answer is incorrect.
					$obtained_marks_sum_subject -= $questions_negative_marks;
					$incorrect_answers_count_subject++;
				}
			}
		}
		?>
		<tbody>
				<tr>
					<td><?php echo esc_html( $subject->subject_name ); ?></td>
					<td><?php echo esc_html( $questions_count_in_subject ); ?></td>
					<td><?php echo esc_html( $questions_attempted_count ); ?></td>
					<!-- <td><?php echo esc_html( $correct_answers_count_subject ); ?></td> -->
					<!-- <td><?php echo esc_html( $incorrect_answers_count_subject ); ?></td> -->
					<td><?php echo esc_html( $maximum_marks_sum_subject ); ?></td>
					<!-- <td><?php echo esc_html( $obtained_marks_sum_subject ); ?></td> -->
				</tr>
			</tbody>
		<?php
	}

	?>

		</table>

