<?php
defined( 'ABSPATH' ) || die();

class OEM_M_Response {
	public static function get_response( $question_id, $student_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT rp.ID, rp.value, rp.is_marked, rp.is_submitted FROM ' . OEM_RESPONSES . ' as rp WHERE rp.question_id = %d AND rp.student_id = %d', $question_id, $student_id )
		);
	}

	public static function fetch_responses( $student_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT q.ID as question_id, rp.ID, rp.is_marked, rp.is_submitted FROM ' . OEM_RESPONSES . ' as rp 
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id 
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id 
				WHERE rp.student_id = %d AND q.exam_id = %d GROUP BY q.ID', $student_id, $exam_id ),
			OBJECT_K
		);
	}

	public static function fetch_saved_option_ids( $response_id ) {
		global $wpdb;

		return $wpdb->get_col(
			$wpdb->prepare( 'SELECT ar.option_id FROM ' . OEM_ANSWERS . ' as ar 
				WHERE ar.response_id = %d', $response_id )
		);
	}
}
