<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Student.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Record.php';

require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam.php';

$student    = '';
$student_id = '';

$nonce_action_student = 'add-student';

$name         = '';
$roll_number  = '';
$class        = '';
$section      = '';
$phone        = '';
$address      = '';
$father_name  = '';
$father_phone = '';
$photo_id     = '';
$username     = '';
$login_email  = '';

$record = '';

if ( isset( $_GET['student_id'] ) && ! empty( $_GET['student_id'] ) ) {
	$student_id = absint( $_GET['student_id'] );
	$student    = OEM_M_Student::fetch_student( $student_id, $exam_id );
	if ( ! $student ) {
		die;
	}

	$nonce_action_student = 'edit-student-' . $student->ID;

	$name           = $student->name;
	$roll_number    = $student->roll_number;
	$class          = $student->class;
	$section        = $student->section;
	$phone          = $student->phone;
	$address        = $student->address;
	$father_name    = $student->father_name;
	$father_phone   = $student->father_phone;
	$photo_id       = $student->photo_id;
	$username       = $student->username;
	$login_email    = $student->login_email;
	$record_user_id = $student->record_user_id;
	$gender         = $student->gender;
	$dob            = $student->dob;
	$id_number      = $student->id_number;

	$record = OEM_M_Record::find( $record_user_id );
}
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<?php require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam_title.php'; ?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-clock"></i>&nbsp;
					<?php echo esc_html( 'View Exams', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row justify-content-md-center">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<?php
						if ( $student ) {
						?>
						<span>
							<i class="fas fa-save"></i>
							<?php esc_html_e( 'Update Student', 'online-exam-management' ); ?>
						</span>
						<?php
						} else {
						?>
						<span>
							<i class="fas fa-plus"></i>
							<?php esc_html_e( 'Add Student', 'online-exam-management' ); ?>
						</span>
						<?php
						}
						?>
						<span>
							<a class="btn btn-sm oem-btn-outline-primary float-right" href="<?php echo esc_url( $page_url . '&action=list&exam_id=' . $exam_id ); ?>#oem-subjects-table_wrapper">
								<i class="fas fa-users"></i>
								<?php esc_html_e( 'View Students', 'online-exam-management' ); ?>
							</a>
						</span>
					</div>

					<div class="oem-section-body">
						<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-save-student-form">

							<?php $nonce_student = wp_create_nonce( $nonce_action_student ); ?>
							<input type="hidden" name="<?php echo esc_attr( $nonce_action_student ); ?>" value="<?php echo esc_attr( $nonce_student ); ?>">

							<input type="hidden" name="action" value="oem-save-student">

							<?php if ( $student ) { ?>
							<input type="hidden" name="student_id" value="<?php echo esc_attr( $student->ID ); ?>">
							<?php } ?>

							<input type="hidden" name="exam_id" value="<?php echo esc_attr( $exam->ID ); ?>">

							<div class="form-row">
								<div class="col-12 col-md-12">
									<?php require_once 'fields/student_detail.php'; ?>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-12">
									<?php require_once 'fields/login_detail.php'; ?>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-12 text-right">
									<?php require_once 'fields/submit_button.php'; ?>
								</div>
							</div>
						</form>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>
