<?php
defined( 'ABSPATH' ) || die();
?>
<div class="oem-section">
	<div class="oem-section-header">
		<span><?php esc_html_e( 'Student Detail', 'online-exam-management' ); ?></span>
		<?php if ( $record ) { ?>
		<span class="float-right">
			<span>
				<?php esc_html_e( 'Registration No.', 'online-exam-management' ); ?>
			</span>
			<span>
				<a target="_blank" href="<?php echo esc_url( $records_page_url . '&action=exams&record_id=' . $record->ID ); ?>" class="oem-text-primary">
					<?php echo esc_html( $record->oem_reg_number ); ?>
				</a>
			</span>
		</span>
		<?php } ?>
	</div>

	<div class="oem-section-body">
		<div class="form-row">
			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_name" class="oem-font-bold">
						<span class="oem-important">*</span> <?php esc_html_e( 'Student Name', 'online-exam-management' ); ?>:
					</label>
					<input type="text" name="name" class="form-control" id="oem_name" placeholder="<?php esc_attr_e( 'Enter student name', 'online-exam-management' ); ?>" value="<?php echo esc_attr( OEM_Helper::stripslashes( $name ) ); ?>">
				</div>
			</div>

			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_roll_number" class="oem-font-bold">
						<?php esc_html_e( 'Roll Number', 'online-exam-management' ); ?>:
					</label>
					<input type="text" name="roll_number" class="form-control" id="oem_roll_number" placeholder="<?php esc_attr_e( 'Enter roll number', 'online-exam-management' ); ?>" value="<?php echo esc_attr( OEM_Helper::get_text( $roll_number ) ); ?>">
					<?php if ( ! $student ) { ?>
					<p class="description"><?php esc_html_e( 'Roll number will be auto-generated if empty.', 'online-exam-management' ); ?></p>
					<?php } ?>
				</div>
			</div>

			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_class" class="oem-font-bold">
						<?php esc_html_e( 'Class', 'online-exam-management' ); ?>:
					</label>
					<input type="text" name="class" class="form-control" id="oem_class" placeholder="<?php esc_attr_e( 'Enter class', 'online-exam-management' ); ?>" value="<?php echo esc_attr( OEM_Helper::stripslashes( $class ) ); ?>">
				</div>
			</div>

			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_section" class="oem-font-bold">
						<?php esc_html_e( 'Section', 'online-exam-management' ); ?>:
					</label>
					<input type="text" name="section" class="form-control" id="oem_section" placeholder="<?php esc_attr_e( 'Enter section', 'online-exam-management' ); ?>" value="<?php echo esc_attr( OEM_Helper::stripslashes( $section ) ); ?>">
				</div>
			</div>

			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_phone" class="oem-font-bold">
						<?php esc_html_e( 'Phone Number', 'online-exam-management' ); ?>:
					</label>
					<input type="text" name="phone" class="form-control" id="oem_phone" placeholder="<?php esc_attr_e( 'Enter phone number', 'online-exam-management' ); ?>" value="<?php echo esc_attr( OEM_Helper::get_text( $phone ) ); ?>">
				</div>
			</div>

			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_address" class="oem-font-bold">
						<?php esc_html_e( 'Address', 'online-exam-management' ); ?>:
					</label>
					<textarea name="address" class="form-control" id="oem_address" cols="30" rows="3" placeholder="<?php esc_attr_e( 'Enter address', 'online-exam-management' ); ?>"><?php echo esc_html( OEM_Helper::get_text( $address ) ); ?></textarea>
				</div>
			</div>

			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_father_name" class="oem-font-bold">
						<?php esc_html_e( "Father's Name", 'online-exam-management' ); ?>:
					</label>
					<input type="text" name="father_name" class="form-control" id="oem_father_name" placeholder="<?php esc_attr_e( "Enter father's name", 'online-exam-management' ); ?>" value="<?php echo esc_attr( OEM_Helper::stripslashes( $father_name ) ); ?>">
				</div>
			</div>

			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_father_phone" class="oem-font-bold">
						<?php esc_html_e( "Father's Phone", 'online-exam-management' ); ?>:
					</label>
					<input type="text" name="father_phone" class="form-control" id="oem_father_phone" placeholder="<?php esc_attr_e( "Enter father's phone number", 'online-exam-management' ); ?>" value="<?php echo esc_attr( OEM_Helper::get_text( $father_phone ) ); ?>">
				</div>
			</div>

			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_dob" class="oem-font-bold">
						<?php esc_html_e( "Date Of Birth", 'online-exam-management' ); ?>:
					</label>
					<input type="text" name="dob" class="form-control oem_date" id="oem_dob" placeholder="<?php esc_attr_e( "Enter dob number", 'online-exam-management' ); ?>" value="<?php echo esc_attr( OEM_Helper::get_date_text(($dob) ) ); ?>">
				</div>
			</div>	

			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_id_number" class="oem-font-bold">
						<?php esc_html_e( "ID Number", 'online-exam-management' ); ?>:
					</label>
					<input type="text" name="id_number" class="form-control" id="oem_id_number" placeholder="<?php esc_attr_e( "Enter id number number", 'online-exam-management' ); ?>" value="<?php echo esc_attr( OEM_Helper::get_text( isset($id_number) ) ); ?>">
				</div>
			</div>
				<?php 
				$genders = [
					'male'   => 'Male',
					'female' => 'Female',
					'other'  => 'Other',
					]
				?>					
			<div class="col-md-3">
				<div class="form-group">
					<label for="oem_gender" class="oem-font-bold">
						<?php esc_html_e( "gender", 'online-exam-management' ); ?>:
					</label>
					<select name="gender" class="form-control selectpicker" id="oem_gender" data-live-search="true" title="<?php esc_attr_e( 'gender', 'online-exam-management' ); ?>">
							<?php foreach ( $genders as $key => $value ) { ?>
							<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $gender, $key, true ); ?>>
								<?php echo esc_html( $value ); ?>
							</option>
							<?php } ?>
						</select>
				</div>
			</div>

			<div class="col-md-3">
				<div class="form-group">
					<div class="oem-photo-box">
						<div class="oem-photo-section">
							<label for="oem_photo" class="oem-font-bold">
								<?php esc_html_e( 'Upload Student Photo', 'online-exam-management' ); ?>:
							</label><br>
							<?php if ( ! empty ( $photo_id ) ) { ?>
								<img src="<?php echo esc_url( wp_get_attachment_url( $photo_id ) ); ?>" class="img-responsive oem-photo">
							<?php } ?>
							<br><br>
							<div class="custom-file mb-3">
								<input type="file" class="custom-file-input" id="oem_photo" name="photo">
								<label class="custom-file-label" for="oem_photo">
									<?php esc_html_e( 'Choose File', 'online-exam-management' ); ?>
								</label>
								<small class="form-text text-muted"><?php esc_html_e( 'Recommended Photo Size: 250 x 320.', 'online-exam-management' ); ?></small>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
