<?php
defined( 'ABSPATH' ) || die();
?>
<div class="row tab-pane fade" id="oem-shortcode" role="tabpanel" aria-labelledby="oem-shortcode-tab">
	<div class="col-12 col-md-12">

		<div class="oem-section">
			<div class="oem-section-header">
				<span>
					<i class="fas fa-code"></i>
					<?php esc_html_e( 'Shortcode', 'online-exam-management' ); ?>
				</span>
			</div>

			<div class="oem-section-body">
				<ul class="list-group oem-shortcodes">

					<li class="list-group-item px-3 py-3">
						<span class="oem_shortcode_description description oem-font-medium">
							<?php esc_html_e( 'To display online exam portal on your page, use the following shortcode:', 'online-exam-management' ); ?>
						</span>

						<span id="oem_online_exam_shortcode" class="oem-font-bold text-dark">[online_exam]</span>

						<button type="button" class="btn btn-sm oem-btn-primary" id="oem_copy_online_exam_shortcode">
							<?php esc_html_e( 'Copy', 'online-exam-management' ); ?>
						</button>
					</li>

					<li class="list-group-item px-3 py-3">
						<span class="oem_shortcode_description description oem-font-medium">
							<?php esc_html_e( 'To display exam results form on your page, use the following shortcode:', 'online-exam-management' ); ?>
						</span>

						<span id="oem_exam_results_shortcode" class="oem-font-bold text-dark">[online_exam_results]</span>

						<button type="button" class="btn btn-sm oem-btn-primary" id="oem_copy_exam_results_shortcode">
							<?php esc_html_e( 'Copy', 'online-exam-management' ); ?>
						</button>
						<p class="description"><?php esc_html_e( 'Only exams with "Show in Exam Results Form" set to "Yes" will be listed.', 'online-exam-management' ); ?></p>
					</li>

					<li class="list-group-item px-3 py-3">
						<span class="oem_shortcode_description description oem-font-medium">
							<?php esc_html_e( 'To display registration and fee payment form on your page, use the following shortcode:', 'online-exam-management' ); ?>
						</span>

						<span id="oem_exam_registration_shortcode" class="oem-font-bold text-dark">[online_exam_registration]</span>

						<button type="button" class="btn btn-sm oem-btn-primary" id="oem_copy_exam_registration_shortcode">
							<?php esc_html_e( 'Copy', 'online-exam-management' ); ?>
						</button>
						<p class="description"><?php esc_html_e( 'Only upcoming exams with "Show in Registration Form" set to "Yes" will be listed.', 'online-exam-management' ); ?></p>
					</li>

				</ul>
			</div>
		</div>

	</div>
</div>
