<?php
defined('ABSPATH') || die();
?>
<div class="row tab-pane fade " id="oem-reset" role="tabpanel" aria-labelledby="oem-reset-tab">
    <div class="col-12 col-md-12 ">

        <div class="oem-section">
            <div class="oem-section-header">
                <span>
                    <i class="fas fa-code"></i>
                    <?php esc_html_e('Reset', 'online-exam-management'); ?>
                </span>
            </div>

            <div class="oem-section-body text-center">
                <form action="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" method="post" id="oem-reset-plugin-form">
                    <?php
                    $nonce_action = 'reset-plugin';
                    $nonce        = wp_create_nonce($nonce_action);
                    ?>
                    <input type="hidden" name="<?php echo esc_attr($nonce_action); ?>" value="<?php echo esc_attr($nonce); ?>">

                    <input type="hidden" name="action" value="oem-reset-plugin">

                    <div class="mb-3 mt-1 alert alert-info">
                        <?php esc_html_e('Here, you can reset the plugin to its initial state.', 'online-exam-management'); ?>
                    </div>

                    <div class="ml-4 mb-2 mt-2 oem-font-bold">
                        <?php esc_html_e('This will:', 'online-exam-management'); ?>
                    </div>

                    <ul class="list-group list-group-flush text-dark">
                        <li class="list-group-item">
                            * <?php esc_html_e('Recreate all database tables.', 'online-exam-management'); ?>
                        </li>
                        <li class="list-group-item">
                            * <?php esc_html_e('Reset all settings.', 'online-exam-management'); ?>
                        </li>
                    </ul>

                    <div class="mt-3 ">
                        <button type="button" class="btn btn-danger" id="oem-reset-plugin-btn" data-message-title="<?php esc_attr_e('Reset Plugin!', 'online-exam-management'); ?>" data-message-content="<?php esc_attr_e('Are you sure to reset the plugin to its initial state?', 'online-exam-management'); ?>" data-submit="<?php esc_attr_e('Reset', 'online-exam-management'); ?>" data-cancel="<?php esc_attr_e('Cancel', 'online-exam-management'); ?>">
                            <i class="fas fa-redo"></i>&nbsp;
                            <?php esc_html_e('Reset Plugin', 'online-exam-management'); ?>
                        </button>
                    </div>
                </form>
            </div>

        </div>

    </div>
</div>