<?php
defined( 'ABSPATH' ) || die();

// Razorpay settings.
$razorpay        = OEM_Helper::razorpay();
$razorpay_enable = $razorpay['enable'];
$razorpay_key    = $razorpay['key'];
$razorpay_secret = $razorpay['secret'];

// Stripe settings.
$stripe        = OEM_Helper::stripe();
$stripe_enable = $stripe['enable'];
$stripe_key    = $stripe['key'];
$stripe_secret = $stripe['secret'];

$nonce_action_payment_methods_settings = 'save-payment-methods-settings';
?>
<div class="row tab-pane fade" id="oem-payment-methods" role="tabpanel" aria-labelledby="oem-payment-methods-tab">
	<div class="col-12 col-md-12">
		<div class="oem-section">
			<div class="oem-section-header">
				<span>
					<i class="fas fa-dollar-sign"></i>
					<?php esc_html_e( 'Payment Methods Settings', 'online-exam-management' ); ?>
				</span>
			</div>

			<div class="oem-section-body">
				<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-save-payment-methods-settings-form">

					<?php $nonce_payment_methods_settings = wp_create_nonce( $nonce_action_payment_methods_settings ); ?>
					<input type="hidden" name="<?php echo esc_attr( $nonce_action_payment_methods_settings ); ?>" value="<?php echo esc_attr( $nonce_payment_methods_settings ); ?>">

					<input type="hidden" name="action" value="oem-save-payment-methods-settings">

					<div class="form-row">
						<div class="col-12 col-md-6">
							<button type="button" class="mt-2 btn oem-btn-primary btn-block" data-toggle="collapse" data-target="#oem_razorpay_fields" aria-expanded="true" aria-controls="oem_razorpay_fields">
								<?php esc_html_e( 'Razorpay Payment Gateway', 'online-exam-management' ); ?>
							</button>
						</div>
					</div>

					<div class="collapse p-3" id="oem_razorpay_fields">

						<div class="form-row">
							<div class="col-12 col-md-4">
								<div class="form-group">
									<label for="oem_razorpay_enable" class="oem-font-bold">
										<input <?php checked( $razorpay_enable, true, true ); ?> type="checkbox" name="razorpay_enable" id="oem_razorpay_enable" value="1">
										<?php esc_html_e( 'Enable Razorpay Payment', 'online-exam-management' ); ?>
									</label>
									<?php if ( ! OEM_Helper::currency_supports_razorpay( $currency ) ) { ?>
									<p class="description oem-text-danger">
										<?php
										printf(
											/* translators: %s: currency code */
											__( 'Razorpay does not support currency %s.', 'online-exam-management' ),
											esc_html( $currency )
										);
										?>
									</p>
									<?php } ?>
								</div>

								<div class="form-group">
									<label for="oem_razorpay_key" class="oem-font-bold">
										<?php esc_html_e( 'Razorpay Key', 'online-exam-management' ); ?>:
									</label>
									<input type="text" name="razorpay_key" class="form-control" id="oem_razorpay_key" placeholder="<?php esc_attr_e( 'Razorpay Key', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $razorpay_key ); ?>">
								</div>

								<div class="form-group">
									<label for="oem_razorpay_secret" class="oem-font-bold">
										<?php esc_html_e( 'Razorpay Secret', 'online-exam-management' ); ?>:
									</label>
									<input type="text" name="razorpay_secret" class="form-control" id="oem_razorpay_secret" placeholder="<?php esc_attr_e( 'Razorpay Secret', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $razorpay_secret ); ?>">
								</div>
							</div>
						</div>

					</div>
					<div class="form-row">
						<div class="col-12 col-md-6">
							<button type="button" class="mt-2 btn oem-btn-primary btn-block" data-toggle="collapse" data-target="#oem_stripe_fields" aria-expanded="true" aria-controls="oem_stripe_fields">
								<?php esc_html_e( 'Stripe Payment Gateway', 'online-exam-management' ); ?>
							</button>
						</div>
					</div>

					<div class="collapse p-3" id="oem_stripe_fields">

						<div class="form-row">
							<div class="col-12 col-md-4">
								<div class="form-group">
									<label for="oem_stripe_enable" class="oem-font-bold">
										<input <?php checked( $stripe_enable, true, true ); ?> type="checkbox" name="stripe_enable" id="oem_stripe_enable" value="1">
										<?php esc_html_e( 'Enable Stripe Payment', 'online-exam-management' ); ?>
									</label>
									<?php if ( ! OEM_Helper::currency_supports_stripe( $currency ) ) { ?>
									<p class="description oem-text-danger">
										<?php
										printf(
											/* translators: %s: currency code */
											__( 'Stripe does not support currency %s.', 'online-exam-management' ),
											esc_html( $currency )
										);
										?>
									</p>
									<?php } ?>
								</div>

								<div class="form-group">
									<label for="oem_stripe_key" class="oem-font-bold">
										<?php esc_html_e( 'Stripe Publishable Key', 'online-exam-management' ); ?>:
									</label>
									<input type="text" name="stripe_key" class="form-control" id="oem_stripe_key" placeholder="<?php esc_attr_e( 'Stripe Publishable Key', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $stripe_key ); ?>">
								</div>

								<div class="form-group">
									<label for="oem_stripe_secret" class="oem-font-bold">
										<?php esc_html_e( 'Stripe Secret key', 'online-exam-management' ); ?>:
									</label>
									<input type="text" name="stripe_secret" class="form-control" id="oem_stripe_secret" placeholder="<?php esc_attr_e( 'Stripe Secret Key', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $stripe_secret ); ?>">
								</div>
							</div>
						</div>

					</div>

					<div class="form-row mt-3">
						<div class="col-12 col-md-12">
							<button type="submit" class="btn btn-sm oem-btn-primary" id="oem-save-payment-methods-settings-btn">
								<?php esc_html_e( 'Save Settings', 'online-exam-management' ); ?>
							</button>
						</div>
					</div>

				</form>
			</div>
		</div>

	</div>
</div>
