<?php
defined( 'ABSPATH' ) || die();

$currency = OEM_Helper::currency();

$currency_symbols = OEM_Helper::currency_symbols();

$exam_page_url = OEM_Helper::online_exam_page_url();

$registration_page_url = OEM_Helper::registration_page_url();

$enable_photo = OEM_Helper::enable_photo();

$nonce_action_general_settings = 'save-general-settings';
?>
<div class="row tab-pane fade show active" id="oem-general" role="tabpanel" aria-labelledby="oem-general-tab">
	<div class="col-12 col-md-12">

		<div class="oem-section">
			<div class="oem-section-header">
				<span>
					<i class="fas fa-cog"></i>
					<?php esc_html_e( 'General Settings', 'online-exam-management' ); ?>
				</span>
			</div>

			<div class="oem-section-body">
				<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-save-general-settings-form">

					<?php $nonce_general_settings = wp_create_nonce( $nonce_action_general_settings ); ?>
					<input type="hidden" name="<?php echo esc_attr( $nonce_action_general_settings ); ?>" value="<?php echo esc_attr( $nonce_general_settings ); ?>">

					<input type="hidden" name="action" value="oem-save-general-settings">

					<div class="form-row">
						<div class="col-12 col-md-3">
							<div class="form-group">
								<label for="oem_currency" class="oem-font-bold">
									<?php esc_html_e( 'Currency', 'online-exam-management' ); ?>:
								</label>
								<select name="currency" class="form-control selectpicker" id="oem_currency" data-live-search="true">
									<?php foreach ( $currency_symbols as $key => $value ) { ?>
									<option <?php selected( $key, $currency, true ); ?> value="<?php echo esc_attr( $key ); ?>" <?php selected( $currency, $key, true ); ?>>
										<?php echo esc_attr( $key ); ?>
									</option>
									<?php } ?>
								</select>
							</div>
						</div>
					</div>

					<div class="form-row">
						<div class="col-12 col-md-6">
							<div class="form-group">
								<label for="oem_exam_page_url" class="oem-font-bold">
									<?php esc_html_e( 'Online Exam Page URL', 'online-exam-management' ); ?>:
								</label>
								<input type="text" name="exam_page_url" class="form-control" id="oem_exam_page_url" placeholder="<?php esc_attr_e( 'Enter online exam page URL', 'online-exam-management' ); ?>" value="<?php echo esc_url( $exam_page_url ); ?>">
								<p class="description"><?php esc_html_e( 'Enter page URL where you use the shortcode: [online_exam]', 'online-exam-management' ); ?></p>
							</div>
						</div>
					</div>

					<div class="form-row">
						<div class="col-12 col-md-6">
							<div class="form-group">
								<label for="oem_registration_page_url" class="oem-font-bold">
									<?php esc_html_e( 'Registration Page URL', 'online-exam-management' ); ?>:
								</label>
								<input type="text" name="registration_page_url" class="form-control" id="oem_registration_page_url" placeholder="<?php esc_attr_e( 'Enter registration page URL', 'online-exam-management' ); ?>" value="<?php echo esc_url( $registration_page_url ); ?>">
								<p class="description"><?php esc_html_e( 'Enter page URL where you use the shortcode: [online_exam_registration]', 'online-exam-management' ); ?></p>
							</div>
						</div>
					</div>

					<div class="form-row">
						<div class="col-12 col-md-6">
							<div class="form-group">
								<label for="oem_exam_page_url" class="oem-font-bold">
									<?php esc_html_e( 'Online Exam Photo Capture', 'online-exam-management' ); ?>:
								</label><br>
								<input type="radio" name="enable_photo" class="form-control" value="1" <?php if ($enable_photo == '1') {
									echo 'checked';
								} ?>>
								<label for="male"><?php esc_html_e( 'Enable', 'online-exam-management' ); ?></label><br>
								<input type="radio" name="enable_photo" class="form-control" value="0" <?php if (!$enable_photo) {
									echo 'checked';
								} ?>>
								<label for="male"><?php esc_html_e( 'Disable', 'online-exam-management' ); ?></label><br>
							</div>
						</div>
					</div>


					<div class="form-row">
						<div class="col-12 col-md-12">
							<button type="submit" class="btn btn-sm oem-btn-primary" id="oem-save-general-settings-btn">
								<?php esc_html_e( 'Save Settings', 'online-exam-management' ); ?>
							</button>
						</div>
					</div>

				</form>
			</div>
		</div>

	</div>
</div>
