<?php
defined( 'ABSPATH' ) || die();

$record    = '';
$record_id = '';

if ( isset( $_GET['record_id'] ) && ! empty( $_GET['record_id'] ) ) {
	$record_id = absint( $_GET['record_id'] );
	$record    = OEM_M_Record::find( $record_id );
}

if ( ! $record ) {
	die;
}

$nonce_action_record = 'edit-record-' . $record->ID;

$reg_number   = $record->oem_reg_number;
$name         = $record->oem_name;
$phone        = $record->oem_phone;
$address      = $record->oem_address;
$father_name  = $record->oem_father_name;
$father_phone = $record->oem_father_phone;
$photo_id     = $record->oem_photo_id;
$login_email  = $record->user_email;
$username     = $record->user_login;
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<i class="fas fa-user"></i>
				<?php
				printf(
					wp_kses(
						/* translators: %s: registraion number */
						__( 'View / Edit Registration: <span class="oem-font-light">%s</span>', 'online-exam-management' ),
						array(
							'span' => array( 'class' => array() )
						)
					),
					esc_html( $reg_number )
				);
				?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-users"></i>&nbsp;
					<?php echo esc_html( 'View All', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-save"></i>
							<?php esc_html_e( 'Update Registration Detail', 'online-exam-management' ); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-save-record-form">

							<?php $nonce_record = wp_create_nonce( $nonce_action_record ); ?>
							<input type="hidden" name="<?php echo esc_attr( $nonce_action_record ); ?>" value="<?php echo esc_attr( $nonce_record ); ?>">

							<input type="hidden" name="action" value="oem-save-record">

							<input type="hidden" name="record_id" value="<?php echo esc_attr( $record->ID ); ?>">

							<div class="form-row">
								<div class="col-12 col-md-12">
									<?php require_once 'fields/student_detail.php'; ?>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-12">
									<?php require_once 'fields/login_detail.php'; ?>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-12 text-right">
									<button type="submit" class="btn btn-sm oem-btn-primary" id="oem-save-record-btn">
										<i class="fas fa-save"></i>&nbsp;
										<?php esc_html_e( 'Update Registration', 'online-exam-management' ); ?>
									</button>
								</div>
							</div>

						</form>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>
