<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Record.php';

$registration_search_fields = OEM_Helper::registration_search_fields();
$registration_meta_fields   = OEM_Helper::registration_meta_fields();

// Search meta query.
$s_meta_query = array();

// Search columns query.
$s_columns_query = array();

// Search registrations.
$s_field = isset( $_GET['s_field'] ) ? sanitize_text_field( $_GET['s_field'] ) : '';
$s_value = isset( $_GET['s_value'] ) ? sanitize_text_field( $_GET['s_value'] ) : '';
if ( $s_field && $s_value ) {
	if ( in_array( $s_field, $registration_meta_fields ) ) {
		// Apply meta query.
		array_push(
			$s_meta_query,
			array(
				'key'     => 'oem_' . $s_field,
				'value'   => $s_value,
				'compare' => 'LIKE'
			)
		);

	} elseif ( 'user_field' === $s_field ) {
		// Apply columns query.
		$s_columns_query = array(
			'search'         => '*' . esc_attr( $s_value ) . '*',
			'search_columns' => array( 'user_login', 'user_email' )
		);
	}
}

$current_page = isset( $_GET['cpage'] ) ? absint( $_GET['cpage'] ) : 1;
$per_page     = 25;

$user_query = OEM_M_Record::query( $current_page, $per_page, $s_meta_query, $s_columns_query );

$total = $user_query->get_total();
$users = $user_query->get_results();

$total_pages = ceil( $total / $per_page );
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<i class="fas fa-users"></i>
				<?php esc_html_e( 'Registrations', 'online-exam-management' ); ?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $payments_page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-dollar-sign"></i>&nbsp;
					<?php echo esc_html( 'View Payments', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-users"></i>
							<?php esc_html_e( 'View and Manage Registrations', 'online-exam-management' ); ?>
						</span>
						<span class="float-right">
							<form action="" class="form-inline">
								<input type="hidden" name="page" value="<?php echo esc_attr( $_GET['page'] ); ?>">
								<div class="form-group">
									<select name="s_field" class="form-control oem-input-small">
										<?php foreach ( $registration_search_fields as $key => $value ) { ?>
										<option <?php selected( $s_field, $key, true ); ?> value="<?php echo esc_attr( $key ); ?>">
											<?php echo esc_html( $value ); ?>
										</option>
										<?php } ?>
									</select>
								</div>
								<div class="form-group ml-1">
									<input type="text" name="s_value" class="form-control oem-input-small" value="<?php echo esc_attr( $s_value ); ?>">
								</div>
								<button class="btn btn-sm oem-btn-primary ml-1" type="submit"><?php esc_html_e( 'Search', 'online-exam-management' ); ?></button>
							</form>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="oem-table-block">
							<table class="table table-hover table-bordered" id="oem-records-table">
							<?php  $entity = 'registered';
							require OEM_PLUGIN_DIR_PATH . 'includes/partials/bulk_action.php'; ?>
								<thead>
									<tr class="text-white oem-bg-primary">
									    <th><input type="checkbox" name="select_all" id="oem-select-all" value="1"></th>
										<th scope="col"><?php esc_html_e( 'Registration No.', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Name', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Phone', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Login Email', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Username', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Registration Date', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Exams', 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Action', 'online-exam-management' ); ?></th>
									</tr>
								</thead>

								<tbody>
								<?php
								if ( ! empty( $users ) ) {
									foreach ( $users as $record ) {
										$exams_count = OEM_M_Record::get_record_students_exams_count( $record->ID );
									?>
									<tr>
										<td><input type="checkbox" class="oem-select-single oem-bulk-students" name="bulk_data[]" value=" <?php echo esc_attr($record->ID); ?>"> </td>
										<td><?php echo esc_html( $record->oem_reg_number ); ?></td>
										<td><?php echo esc_html( $record->oem_name ); ?></td>
										<td><?php echo esc_html( OEM_Helper::get_text( $record->oem_phone, '-' ) ); ?></td>
										<td><?php echo esc_html( $record->user_email ); ?></td>
										<td><?php echo esc_html( $record->user_login ); ?></td>
										<td><?php echo esc_html( OEM_Helper::get_at_text_r( $record->user_registered ) ); ?></td>
										<td>
											<?php echo esc_html( $exams_count ); ?>
											<?php if ( $exams_count > 0 ) { ?>
											&nbsp; - 
											<a class="btn oem-btn-xs oem-btn-primary" href="<?php echo esc_url( $page_url . '&action=exams&record_id=' . $record->ID ); ?>">
												<?php esc_html_e( 'Exams', 'online-exam-management' ); ?>
											</a>
											<?php } ?>
										</td>
										<td>
											<a class="oem-text-primary" href="<?php echo esc_url( $page_url . '&action=profile&record_id=' . $record->ID ); ?>">
												<span class="dashicons dashicons-admin-users"></span>
											</a>&nbsp;&nbsp;
											<a class="oem-text-primary" href="<?php echo esc_url( $page_url . '&action=save&record_id=' . $record->ID ); ?>">
												<span class="dashicons dashicons-edit"></span>
											</a>&nbsp;&nbsp;
											<a class="oem-text-danger oem-delete-record" data-nonce="<?php echo esc_attr( wp_create_nonce( 'delete-record-' . $record->ID ) ); ?>" href="#" data-record="<?php echo esc_attr( $record->ID ); ?>" data-message-title="<?php esc_attr_e( 'Please Confirm!', 'online-exam-management' ); ?>" data-message-content="<?php esc_attr_e( 'This will delete the registration.', 'online-exam-management' ); ?>"  data-cancel="<?php esc_attr_e( 'Cancel', 'online-exam-management' ); ?>" data-submit="<?php esc_attr_e( 'Confirm', 'online-exam-management' ); ?>">
												<span class="dashicons dashicons-trash"></span>
											</a>
										</td>
									</tr>
									<?php
									}
								} else {
									?>
									<tr class="text-center">
										<td colspan="8"><?php esc_html_e( 'No registration found.', 'online-exam-management' ); ?></td>
									</tr>
									<?php
								}
								?>
								</tbody>
							</table>
						</div>

						<div class="oem-pagination">
						<?php
						echo paginate_links(
							array(
								'base'      => add_query_arg( 'cpage', '%#%' ),
								'format'    => '',
								'prev_text' => '&laquo;',
								'next_text' => '&raquo;',
								'total'     => $total_pages,
								'current'   => $current_page
							)
						);
						?>
						</div>
					</div>
				</div>

			</div>
		</div>

	</div>
</div>
