<?php
defined( 'ABSPATH' ) || die();
?>
<div class="oem-section">
	<div class="oem-section-header">
		<span><?php esc_html_e( 'Login Detail', 'online-exam-management' ); ?></span>
	</div>

	<div class="oem-section-body">
		<div class="form-row">
			<div class="form-group col-md-4">
				<label for="oem_username" class="oem-font-bold">
					<span class="oem-important">*</span> <?php esc_html_e( 'Username', 'online-exam-management' ); ?>:
					<small>
						<em class="text-secondary">
						<?php esc_html_e( 'Usernames cannot be changed.', 'online-exam-management' ); ?>
						</em>
					</small>
				</label>
				<input type="text" name="username" class="form-control" id="oem_username" value="<?php echo esc_attr( $username ); ?>" readonly>
			</div>

			<div class="form-group col-md-4">
				<label for="oem_new_login_email" class="oem-font-bold">
					<?php esc_html_e( 'Login Email', 'online-exam-management' ); ?>:
				</label>
				<input type="email" name="new_login_email" class="form-control" id="oem_new_login_email" placeholder="<?php esc_attr_e( 'Enter login email', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $login_email ); ?>">
			</div>

			<div class="form-group col-md-4">
				<label for="oem_new_login_password" class="oem-font-bold">
					<?php esc_html_e( 'Password', 'online-exam-management' ); ?>:
				</label>
				<input type="password" name="new_password" class="form-control" id="oem_new_login_password" placeholder="<?php esc_attr_e( 'Enter password', 'online-exam-management' ); ?>">
			</div>
		</div>
	</div>
</div>
