<?php
defined( 'ABSPATH' ) || die();

$record    = '';
$record_id = '';

if ( isset( $_GET['record_id'] ) && ! empty( $_GET['record_id'] ) ) {
	$record_id = absint( $_GET['record_id'] );
	$record    = OEM_M_Record::find( $record_id );
}

if ( ! $record ) {
	die;
}

$nonce_action_record = 'edit-record-' . $record->ID;

$reg_number   = $record->oem_reg_number;
$name         = $record->oem_name;
$phone        = $record->oem_phone;
$address      = $record->oem_address;
$father_name  = $record->oem_father_name;
$father_phone = $record->oem_father_phone;
$photo_id     = $record->oem_photo_id;
$login_email  = $record->user_email;
$username     = $record->user_login;

$exams = OEM_M_Record::get_record_students_exams( $record->ID );
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<i class="fas fa-clock"></i>
				<?php
				printf(
					wp_kses(
						/* translators: %s: registraion number */
						__( 'Exams for Registration No. <span class="oem-font-light">%s</span>', 'online-exam-management' ),
						array(
							'span' => array( 'class' => array() )
						)
					),
					esc_html( $reg_number )
				);
				?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-users"></i>&nbsp;
					<?php echo esc_html( 'View All', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="far fa-user"></i>
							<?php esc_html_e( 'Registration', 'online-exam-management' ); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="row">
							<div class="col-md-4">
								<ul class="list-group list-group-flush">
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Registration No.', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_text( $reg_number ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Student Name:', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::stripslashes( $name ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Login Email:', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_text( $login_email ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Username:', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_text( $username ) ); ?></span>
									</li>
								</ul>
							</div>

							<div class="col-md-4">
								<ul class="list-group list-group-flush">
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Phone:', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_text( $phone ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Address:', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_text( $address ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( "Father's Name:", 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::stripslashes( $father_name ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( "Father's Phone:", 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_text( $father_phone ) ); ?></span>
									</li>
								</ul>
							</div>

							<?php if ( ! empty ( $photo_id ) ) { ?>
							<div class="col-md-3 my-auto">
								<img src="<?php echo esc_url( wp_get_attachment_url( $photo_id ) ); ?>" class="img-responsive oem-photo ml-1">
							</div>
							<?php } ?>
						</div>
					</div>
				</div>

			</div>
		</div>

		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="far fa-clock"></i>
							<?php esc_html_e( 'Exams', 'online-exam-management' ); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="oem-table-block">
							<table class="table table-hover table-bordered" id="oem-record-exams-table">
								<thead>
									<tr class="text-white oem-bg-primary">
										<th scope="col"><?php esc_html_e( 'Exam Title', 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Exam Code', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Exam Date and Time', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Duration (in minutes)', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Roll Number', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Student Record', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Exam Result', 'online-exam-management' ); ?></th>
									</tr>
								</thead>

								<tbody>
								<?php
								if ( count( $exams ) ) {
									foreach ( $exams as $row ) {
									?>
									<tr>
										<td>
											<?php echo esc_html( OEM_Helper::stripslashes( $row->exam_title ) ); ?>
											<a target="_blank" class="oem-text-primary d-inline-block oem-font-small" href="<?php echo esc_url( $exams_page_url . '&action=save&exam_id=' . $row->ID ); ?>">
												<span class="dashicons dashicons-search"></span>
											</a>
										</td>
										<td><?php echo esc_html( $row->exam_code ); ?></td>
										<td><?php echo esc_html( OEM_Helper::get_at_text( $row->exam_at ) ); ?></td>
										<td><?php echo absint( $row->duration ); ?></td>
										<td><?php echo esc_html( OEM_Helper::get_text( $row->roll_number ) ); ?></td>
										<td>
											<a target="_blank" class="btn oem-btn-xs oem-btn-warning" href="<?php echo esc_url( $students_page_url . '&action=save&exam_id=' . $row->ID . '&student_id=' . $row->student_id ); ?>">
												<?php esc_html_e( 'View Student Record', 'online-exam-management' ); ?>
											</a>
										</td>
										<td>
											<a target="_blank" class="btn oem-btn-xs oem-btn-danger" href="<?php echo esc_url( $results_page_url . '&action=edit&exam_id=' . $row->ID . '&student_id=' . $row->student_id ); ?>">
												<?php esc_html_e( 'View / Edit Result', 'online-exam-management' ); ?>
											</a>
										</td>
									</tr>
									<?php
									}
								} else {
								?>
									<tr class="text-center">
										<td colspan="8"><?php esc_html_e( 'No exam found.', 'online-exam-management' ); ?></td>
									</tr>
								<?php
								}
								?>
								</tbody>
							</table>
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>
