<?php
defined( 'ABSPATH' ) || die();

$payment    = '';
$payment_id = '';

if ( isset( $_GET['payment_id'] ) && ! empty( $_GET['payment_id'] ) ) {
	$payment_id = absint( $_GET['payment_id'] );
	$payment    = OEM_M_Payment::fetch_payment( $payment_id );
}

if ( ! $payment ) {
	die;
}

$amount         = $payment->amount;
$receipt        = $payment->receipt;
$payment_method = $payment->payment_method;
$transaction_id = $payment->transaction_id;
$status         = $payment->status;
$created_at     = $payment->created_at;
$record_id      = $payment->record_user_id;
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<i class="fas fa-dollar-sign"></i>
				<?php
				printf(
					wp_kses(
						/* translators: %s: receipt number */
						__( 'Payment Receipt: <span class="oem-font-light">%s</span>', 'online-exam-management' ),
						array(
							'span' => array( 'class' => array() )
						)
					),
					esc_html( $receipt )
				);
				?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-dollar-sign"></i>&nbsp;
					<?php echo esc_html( 'View All', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-dollar-sign"></i>
							<?php esc_html_e( 'Payment Detail', 'online-exam-management' ); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="row">
							<div class="col-md-4">
								<ul class="list-group list-group-flush">
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Receipt No.', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_text( $receipt ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Amount:', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_money_text( $amount ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Payment Method:', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_payment_method_text( $payment_method ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Transaction ID:', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_text( $transaction_id, '-' ) ); ?></span>
									</li>
								</ul>
							</div>

							<div class="col-md-4">
								<ul class="list-group list-group-flush">
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Status:', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_payment_status_text( $status ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Date:', 'online-exam-management' ); ?></span>
										<span><?php echo esc_html( OEM_Helper::get_at_text( $created_at ) ); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e( 'Registration:', 'online-exam-management' ); ?></span>
										<span>
										<?php if ( $record_id ) { ?>
											<a target="_blank" class="oem-text-primary d-inline-block oem-font-small" href="<?php echo esc_url( $records_page_url . '&action=exams&record_id=' . $record_id ); ?>">
												<span class="dashicons dashicons-search"></span>
											</a>
										<?php } else { ?>
											-
										<?php } ?>
										</span>
									</li>
								</ul>
							</div>
						</div>
					</div>
				</div>

			</div>
		</div>

		<?php
		if ( 'specified' === $payment->access_type ) {
			$exams = OEM_M_Payment::get_payment_exams( $payment_id );
		?>
		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-clock"></i>
							<?php esc_html_e( 'Payment for Exams', 'online-exam-management' ); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="oem-table-block">
							<table class="table table-hover table-bordered" id="oem-record-exams-table">
								<thead>
									<tr class="text-white oem-bg-primary">
										<th scope="col"><?php esc_html_e( 'Exam Title', 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Exam Code', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Exam Date and Time', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Duration (in minutes)', 'online-exam-management' ); ?></th>
									</tr>
								</thead>

								<tbody>
								<?php
								if ( count( $exams ) ) {
									foreach ( $exams as $row ) {
									?>
									<tr>
										<td>
											<?php echo esc_html( OEM_Helper::stripslashes( $row->exam_title ) ); ?>
											<a target="_blank" class="oem-text-primary d-inline-block oem-font-small" href="<?php echo esc_url( $exams_page_url . '&action=save&exam_id=' . $row->ID ); ?>">
												<span class="dashicons dashicons-search"></span>
											</a>
										</td>
										<td><?php echo esc_html( $row->exam_code ); ?></td>
										<td><?php echo esc_html( OEM_Helper::get_at_text( $row->exam_at ) ); ?></td>
										<td><?php echo absint( $row->duration ); ?></td>
									</tr>
									<?php
									}
								} else {
								?>
									<tr class="text-center">
										<td colspan="4"><?php esc_html_e( 'No exam found.', 'online-exam-management' ); ?></td>
									</tr>
								<?php
								}
								?>
								</tbody>
							</table>
						</div>
					</div>
				</div>

			</div>
		</div>
		<?php
		}
		?>
	</div>
</div>
