<?php
defined( 'ABSPATH' ) || die();
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<i class="fas fa-dollar-sign"></i>
				<?php esc_html_e( 'Payments', 'online-exam-management' ); ?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $records_page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-users"></i>&nbsp;
					<?php echo esc_html( 'View Registrations', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-dollar-sign"></i>
							<?php esc_html_e( 'View and Manage Payments', 'online-exam-management' ); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="oem-table-block">
							<table class="table table-hover table-bordered" id="oem-payments-table">
								<thead>
									<tr class="text-white oem-bg-primary">
										<th scope="col"><?php esc_html_e( 'Receipt No.', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Amount', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Payment Method', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Status', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Transaction ID', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Date', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Registration', 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Action', 'online-exam-management' ); ?></th>
									</tr>
								</thead>
							</table>
						</div>
					</div>
				</div>

			</div>
		</div>

	</div>
</div>
