<?php
defined( 'ABSPATH' ) || die();
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<i class="fas fa-clock"></i>
				<?php esc_html_e( 'Online Exams', 'online-exam-management' ); ?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url . '&action=save' ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-plus-square"></i>&nbsp;
					<?php echo esc_html( 'Add New Exam', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="far fa-clock"></i>
							<?php esc_html_e( 'Exams', 'online-exam-management' ); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="oem-table-block">
							<table class="table table-hover table-bordered" id="oem-exams-table">
								<thead>
									<tr class="text-white oem-bg-primary">
										<th scope="col"><?php esc_html_e( 'Exam Title', 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Exam Code', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Exam Date and Time', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Duration (in minutes)', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Number of Questions', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Maximum Marks', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Exam Status', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Subjects', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Questions', 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Action', 'online-exam-management' ); ?></th>
									</tr>
								</thead>
							</table>
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>
