<?php
defined( 'ABSPATH' ) || die();
?>
<div class="oem-section oem-section-options">
	<div class="oem-section-header">
		<span><?php esc_html_e( 'Options', 'online-exam-management' ); ?></span>
	</div>

	<div class="oem-section-body">
		<?php
		if ( empty( $options ) ) {
			for ( $i = 0; $i < $number_of_options; $i++ ) {
				$key        = $i;
				$value      = '';
				$is_correct = false;
				require 'option.php';
			}
		} else {
			foreach ( $options as $key => $option ) {
				?>
				<input type="hidden" name="existing_option_id[<?php echo esc_attr( $key ); ?>]" value="<?php echo esc_attr( $option->ID ); ?>">
				<?php
				$value      = $option->value;
				$is_correct = (bool) $option->is_correct;
				require 'option.php';
			}
		}
		?>
	</div>
</div>

<div class="modal fade" id="oem-option-editor-modal" role="dialog">
	<div class="modal-dialog mw-100 w-75">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title"><?php esc_attr_e( 'Rich Editor', 'online-exam-management' ); ?></h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body">
				<p>
					<?php
					$settings = array(
						'media_buttons' => true,
						'textarea_rows' => 6,
						'wpautop'       => false,
					);
					wp_editor( '', 'oem_option_wpeditor', $settings );
					?>
					<input type="hidden" id="oem_option_id_wpeditor">
				</p>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn oem-btn-primary oem-option-editor-continue-btn" data-dismiss="modal">
					<?php esc_attr_e( 'Continue', 'online-exam-management' ); ?>
				</button>
				<button type="button" class="btn btn-secondary" data-dismiss="modal">
					<?php esc_attr_e( 'Exit', 'online-exam-management' ); ?>
				</button>
			</div>
		</div>
	</div>
</div>
