<?php
defined( 'ABSPATH' ) || die();
?>
<div class="col-12 col-md-4">
	<div class="form-group">
		<label for="oem_roll_no_prefix" class="oem-font-bold">
			<?php esc_html_e( 'Roll Number Prefix', 'online-exam-management' ); ?>:
		</label>
		<input type="text" name="roll_no_prefix" class="form-control" id="oem_roll_no_prefix" placeholder="<?php esc_attr_e( 'Enter roll number prefix', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $roll_no_prefix ); ?>">
		<p class="description"><?php esc_html_e( 'Prefix to add on auto-generated, new roll numbers.', 'online-exam-management' ); ?></p>
	</div>
</div>
<div class="col-12 col-md-4">
	<div class="form-group">
		<label for="oem_roll_no_base" class="oem-font-bold">
			<?php esc_html_e( 'Roll Number Base', 'online-exam-management' ); ?>:
		</label>
		<input type="number" step="1" min="0" name="roll_no_base" class="form-control" id="oem_roll_no_base" placeholder="<?php esc_attr_e( 'Enter roll number base', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $roll_no_base ); ?>">
		<p class="description"><?php esc_html_e( 'If base is 100 and prefix is R, then first auto-generated roll number will be R101.', 'online-exam-management' ); ?></p>
	</div>
</div>
<div class="col-12 col-md-4">
	<div class="form-group">
		<label for="oem_last_roll_no_index" class="oem-font-bold">
			<?php esc_html_e( 'Last Roll Number Index', 'online-exam-management' ); ?>:
		</label>
		<input type="number" step="1" min="0" name="last_roll_no_index" class="form-control" id="oem_last_roll_no_index" placeholder="<?php esc_attr_e( 'Last roll number index', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $last_roll_no_index ); ?>">
		<p class="description"><?php esc_html_e( 'This is the last roll number index which is updated automatically when a new roll number is assigned. You can use this field to reset the last index number.', 'online-exam-management' ); ?></p>
	</div>
</div>
