<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Exam.php';

$exams_page_url    = OEM_Helper::get_page_url('exams');
$students_page_url = OEM_Helper::get_page_url('students');
$results_page_url  = OEM_Helper::get_page_url('results');
$settings_page_url = OEM_Helper::get_page_url('settings');

$exam_stats = OEM_M_Exam::get_exam_stats();

$upcoming_exams = $exam_stats['upcoming_exams'];
$recent_exams   = $exam_stats['recent_exams'];

usort(
	$upcoming_exams,
	function( $a, $b ) {
		return ( strtotime( $a->exam_at ) - strtotime( $b->exam_at ) );
	}
);
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<i class="fas fa-tachometer-alt"></i>
				<?php esc_html_e( 'Dashboard', 'online-exam-management' ); ?>
			</span>
		</div>

		<div class="row">
			<div class="col-md-6">
				<div class="oem-dashboard-section oem-stats">
					<div class="oem-dashboard-section-heading oem-quick-links-heading">
						<?php esc_html_e( 'Exam Stats', 'online-exam-management' ); ?>
					</div>

					<div class="row">
						<div class="col-12 col-md-6">
							<div class="oem-stats-block">
								<span class="oem-stats-title">
									<?php esc_html_e( 'Total Exams', 'online-exam-management' ); ?>
									<i class="fas fa-calculator"></i>
								</span>
								<span class="oem-stats-value"><?php echo esc_html( $exam_stats['count_total'] ); ?></span>
							</div>
						</div>

						<div class="col-12 col-md-6">
							<div class="oem-stats-block oem-stats-block--green">
								<span class="oem-stats-title">
									<?php esc_html_e( 'Exams Completed', 'online-exam-management' ); ?>
									<i class="fas fa-check"></i>
								</span>
								<span class="oem-stats-value"><?php echo esc_html( $exam_stats['count_completed'] ); ?></span>
							</div>
						</div>

						<div class="col-12 col-md-6">
							<div class="oem-stats-block oem-stats-block--orange">
								<span class="oem-stats-title">
									<?php esc_html_e( 'On-going Exams', 'online-exam-management' ); ?>
									<i class="fas fa-clock"></i>
								</span>
								<span class="oem-stats-value"><?php echo esc_html( $exam_stats['count_on_going'] ); ?></span>
							</div>
						</div>

						<div class="col-12 col-md-6">
							<div class="oem-stats-block oem-stats-block--red">
								<span class="oem-stats-title">
									<?php esc_html_e( 'Upcoming Exams', 'online-exam-management' ); ?>
									<i class="fas fa-calendar-alt"></i>
								</span>
								<span class="oem-stats-value"><?php echo esc_html( $exam_stats['count_upcoming'] ); ?></span>
							</div>
						</div>
					</div>
				</div>

				<div class="oem-dashboard-section oem-upcoming-exams">
					<div class="oem-dashboard-section-heading oem-upcoming-exams-heading">
						<?php esc_html_e( 'Upcoming Exams', 'online-exam-management' ); ?>
					</div>

					<?php if ( count( $upcoming_exams ) > 0 ) { ?>
					<ul class="oem-recent-exams-list list-group list-group-flush">
						<?php foreach ( $upcoming_exams as $exam ) { ?>
						<li>
							<a class="oem-dashboard-exam-link" href="<?php echo esc_url( $exams_page_url . '&action=save&exam_id=' . $exam->ID ); ?>">
								<?php
								printf(
									wp_kses(
										/* translators: 1: exam title, 2: exam code */
										__( '<span>%1$s (%2$s)</span>', 'online-exam-management' ),
										array(
											'span' => array( 'class' => array() )
										)
									),
									esc_html( OEM_Helper::stripslashes( $exam->exam_title ) ),
									esc_html( $exam->exam_code )
								);
							 	?>
						 	</a>
							<span class="oem-dashboard-exam-date-time">
								<?php
								printf(
									wp_kses(
										/* translators: 1: exam date and time, 2: number of minutes */
										__( '%1$s <br> <span class="oem-dashboard-duration">- %2$s minutes</span>', 'online-exam-management' ),
										array(
											'br'   => array(),
											'span' => array( 'class' => array() ),
										)
									),
									esc_html( OEM_Helper::get_at_text( $exam->exam_at ) ),
									esc_html( $exam->duration )
								);
							 	?>
							</span>
							<span class="oem-dashboard-exam-links">
								<a class="btn btn-sm oem-btn-success" href="<?php echo esc_url( $exams_page_url . '&action=subjects&&exam_id=' . $exam->ID ); ?>">
									<?php esc_html_e( 'Subjects', 'online-exam-management' ); ?>
								</a>
								<a class="btn btn-sm oem-btn-primary" href="<?php echo esc_url( $exams_page_url . '&action=questions&&exam_id=' . $exam->ID ); ?>">
									<?php esc_html_e( 'Questions', 'online-exam-management' ); ?>
								</a>
								<a class="btn btn-sm oem-btn-warning" href="<?php echo esc_url( $students_page_url . '&action=list&&exam_id=' . $exam->ID ); ?>">
									<?php esc_html_e( 'Students', 'online-exam-management' ); ?>
								</a>
								<a class="btn btn-sm oem-btn-danger" href="<?php echo esc_url( $results_page_url . '&action=list&&exam_id=' . $exam->ID ); ?>">
									<?php esc_html_e( 'Results', 'online-exam-management' ); ?>
								</a>
							</span>
						</li>
						<?php } ?>
					</ul>
					<?php } else { ?>
					<div class="oem-dashboard-exams-not-found">
						<i class="fas fa-exclamation-circle"></i>
						<?php esc_html_e( 'No upcoming exam found.', 'online-exam-management' ); ?>
					</div>
					<?php } ?>
				</div>
			</div>

			<div class="col-md-6">
				<div class="oem-dashboard-section oem-quick-links">
					<div class="oem-dashboard-section-heading oem-quick-links-heading">
						<?php esc_html_e( 'Quick Links', 'online-exam-management' ); ?>
					</div>

					<div class="oem-quick-links-block">
						<a class="btn btn-sm oem-btn-outline-primary" href="<?php echo esc_url( $exams_page_url ); ?>"><?php esc_html_e( 'Manage Exams', 'online-exam-management' ); ?></a>
						<a class="btn btn-sm oem-btn-outline-primary" href="<?php echo esc_url( $students_page_url ); ?>"><?php esc_html_e( 'Manage Students', 'online-exam-management' ); ?></a>
						<a class="btn btn-sm oem-btn-outline-primary" href="<?php echo esc_url( $results_page_url ); ?>"><?php esc_html_e( 'Manage Results', 'online-exam-management' ); ?></a>
						<a class="btn btn-sm oem-btn-outline-primary" href="<?php echo esc_url( $settings_page_url ); ?>"><?php esc_html_e( 'Global Settings', 'online-exam-management' ); ?></a>
					</div>
				</div>

				<div class="oem-dashboard-section oem-recent-exams">
					<div class="oem-dashboard-section-heading oem-recent-exams-heading">
						<?php esc_html_e( 'Recent Exams', 'online-exam-management' ); ?>
					</div>

					<?php if ( count( $recent_exams ) > 0 ) { ?>
					<ul class="oem-recent-exams-list list-group list-group-flush">
						<?php foreach ( $recent_exams as $exam ) { ?>
						<li>
							<a class="oem-dashboard-exam-link" href="<?php echo esc_url( $exams_page_url . '&action=save&exam_id=' . $exam->ID ); ?>">
								<?php
								printf(
									wp_kses(
										/* translators: 1: exam title, 2: exam code */
										__( '<span>%1$s (%2$s)</span>', 'online-exam-management' ),
										array(
											'span' => array( 'class' => array() )
										)
									),
									esc_html( OEM_Helper::stripslashes( $exam->exam_title ) ),
									esc_html( $exam->exam_code )
								);
							 	?>
						 	</a>
							<span class="oem-dashboard-exam-date-time">
								<?php
								printf(
									wp_kses(
										/* translators: 1: exam date and time, 2: number of minutes */
										__( '%1$s <br> <span class="oem-dashboard-duration">- %2$s minutes</span>', 'online-exam-management' ),
										array(
											'br'   => array(),
											'span' => array( 'class' => array() ),
										)
									),
									esc_html( OEM_Helper::get_at_text( $exam->exam_at ) ),
									esc_html( $exam->duration )
								);
							 	?>
							</span>
							<span class="oem-dashboard-exam-links">
								<a class="btn btn-sm oem-btn-success" href="<?php echo esc_url( $exams_page_url . '&action=subjects&&exam_id=' . $exam->ID ); ?>">
									<?php esc_html_e( 'Subjects', 'online-exam-management' ); ?>
								</a>
								<a class="btn btn-sm oem-btn-primary" href="<?php echo esc_url( $exams_page_url . '&action=questions&&exam_id=' . $exam->ID ); ?>">
									<?php esc_html_e( 'Questions', 'online-exam-management' ); ?>
								</a>
								<a class="btn btn-sm oem-btn-warning" href="<?php echo esc_url( $students_page_url . '&action=list&&exam_id=' . $exam->ID ); ?>">
									<?php esc_html_e( 'Students', 'online-exam-management' ); ?>
								</a>
								<a class="btn btn-sm oem-btn-danger" href="<?php echo esc_url( $results_page_url . '&action=list&&exam_id=' . $exam->ID ); ?>">
									<?php esc_html_e( 'Results', 'online-exam-management' ); ?>
								</a>
							</span>
						</li>
						<?php } ?>
					</ul>
					<?php } else { ?>
					<div class="oem-dashboard-exams-not-found">
						<i class="fas fa-exclamation-circle"></i>
						<?php esc_html_e( 'No recent exam found.', 'online-exam-management' ); ?>
					</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</div>
