<?php defined( 'ABSPATH' ) || die(); ?>
<div class="wrap license-container">
	<div class="top_head">
		<div class="column-3">
			<div class="logo-section">
				<img class="logo" src="<?php echo esc_url( OEM_PLUGIN_URL . 'assets/images/logo.png' ); ?>">
			</div>
		</div>
		<div class="column-9">
			<h1><?php esc_html_e( "Thank you for choosing Online Exam Management Plugin", 'online-exam-management' ); ?>!</h1>
			<p class="license_info"><?php esc_html_e( "Please activate this plugin with a purchase code. If you don’t have a purchase code yet, you can purchase it from ", 'online-exam-management' ); ?>
				<a href="https://codecanyon.net/item/online-exam-management/26255739" target="_blank"><?php esc_html_e( 'here', 'online-exam-management' ); ?></a>
			</p>
		</div>
	</div>
	<div class="clearfix"></div>
	<div class="license-section">
		<div class="license-section-inner">
		<h2><?php esc_html_e( 'Let\'s get some work done!', 'online-exam-management' ); ?> </h2>
		<p><?php esc_html_e( 'We have some useful links to get you started', 'online-exam-management' ); ?>: </p>
		<?php
		$oem_lm   = OEM_LM::get_instance();
		$validated = $oem_lm->is_valid();

		if ( isset( $_POST['key'] ) && ! empty( $_POST['key'] ) ) {
			$code = preg_replace( '/[^A-Za-z0-9-_]/', '', trim( $_POST['key'] ) ); 
			if( $oem_lm->validate( $code ) ) {
				$validated = true;
			}
		} else {
			$oem_lm->error_message = esc_html__( "Get Your Purchase Code", 'online-exam-management' ) . ' ' . '<a target="_blank" href="https://codecanyon.net/downloads">' . esc_html__( "Click Here", 'online-exam-management' ) . '</a>';
		} ?>
			<div class="column-6">
		<?php
		if( $validated ) {
		?>
				<h2 class="license-message">
					<?php esc_html_e( 'Purchase Code applied.', 'online-exam-management' ); ?>
					<span><a href="<?php echo admin_url(); ?>"><?php esc_html_e( 'Click here to navigate to dashboard', 'online-exam-management' ); ?></a></span>
				</h2>

				<div class="label">
					<label for="purchase_code"><?php esc_html_e( 'Purchase Code', 'online-exam-management' ); ?>:</label>
				</div>
				<div class="input-box">
					<input id="purchase_code" name="key" type="text" class="regular-text" value="<?php echo "**********************"; ?>" disabled>
				</div>
				<div class="Configuration_btn">
					<h2><?php esc_html_e( 'Congratulation! Online Exam Management Plugin is activated.', 'online-exam-management' ); ?></h2>
					<div class="">
						<a class="conf_btn" href="<?php echo esc_url( get_admin_url() . 'admin.php?page=oem-settings' ); ?>"><?php esc_html_e( 'Plugin Configuration Click Here', 'online-exam-management' ); ?></a>
					</div>
				</div>
		<?php
		} else {
			if ( $oem_lm->error_message ) { ?>
				<h3 class="license-message"><?php echo wp_kses( $oem_lm->error_message, array( 'a' ) ); ?></h3>
			<?php
			} ?>
				<form method='post'>
					<div class="label">
						<label for="purchase_code"><?php esc_html_e( 'Purchase Code', 'online-exam-management' ); ?>:</label>
					</div>
					<div class="input-box">
						<input id="purchase_code" name="key" type="text" class="regular-text">
					</div>
					<input type="submit" class="button button-primary" value="<?php esc_attr_e( 'Activate', 'online-exam-management' ); ?>">
				</form>
		<?php
		} ?>
			</div>
			<div class="column-6">
				<ul class="weblizar-links">
					<li><h3><?php esc_html_e( 'Getting Started', 'online-exam-management' ); ?></h3></li>
					<li><i class="dashicons dashicons-video-alt3"></i><a target="_blank" href="https://www.youtube.com/channel/UCFve0DTmWU4OTHXAtUOpQ7Q/playlists"><?php esc_html_e( 'Video Tutorial', 'online-exam-management' ); ?></a></li>
					<li><i class="dashicons dashicons-portfolio"></i><a target="_blank" href="https://weblizar.com/plugins/"><?php esc_html_e( 'More Products', 'online-exam-management' ); ?></a></li>
					<li><i class="dashicons dashicons-admin-generic"></i><a target="_blank" href="http://weblizar.com/"><?php esc_html_e( 'Help Center', 'online-exam-management' ); ?></a></a></li>
				</ul>
				<ul class="weblizar-links">
					<li><h3><?php esc_html_e( 'Guides & Support', 'online-exam-management' ); ?></h3></li>
					<li><i class="dashicons dashicons-welcome-view-site"></i><a target="_blank" href="http://demo.weblizar.com/online-exam-management/"><?php esc_html_e( 'Demo', 'online-exam-management' ); ?></a></li>
					<li><i class="dashicons dashicons-admin-users"></i><a target="_blank" href="https://weblizar.com/documentation/online-exam-management/"><?php esc_html_e( 'Documentation guide', 'online-exam-management' ); ?></a></li>
					<li><i class="dashicons dashicons-format-status"></i><a target="_blank" href="https://weblizar.com/forum/"><?php esc_html_e( 'Support forum', 'online-exam-management' ); ?></a></li>
				</ul>
				<div class="clearfix"></div>
				<div class="wlim-change-log">
					<div class="wlim-change-log-title-box">
						<div class="change-log-title"><a target="_blank" href="<?php echo esc_url( OEM_PLUGIN_URL . 'changelog.txt' ); ?>"><?php echo esc_html_e( 'Change Log', 'online-exam-management' ); ?></a></div>
					</div>
				</div>
			</div>
		</div>		
	</div>
</div>
