<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Database.php';

class OEM_Setting {
	public static function save_general() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		OEM_Helper::check_nonce( 'save-general-settings' );

		$errors = array();

		$currency              = isset( $_POST['currency'] ) ? sanitize_text_field( $_POST['currency'] ) : '';
		$registration_page_url = isset( $_POST['registration_page_url'] ) ? esc_url_raw( $_POST['registration_page_url'] ) : '';
		$exam_page_url         = isset( $_POST['exam_page_url'] ) ? esc_url_raw( $_POST['exam_page_url'] ) : '';
		$enable_photo         = isset( $_POST['enable_photo'] ) ? sanitize_text_field( $_POST['enable_photo'] ) : '0';

		$currency_symbols = OEM_Helper::currency_symbols();

		if ( ! in_array( $currency, array_keys( $currency_symbols ) ) ) {
			$currency = OEM_Helper::get_default_currency();
		}

		if ( count( $errors ) > 0 ) {
			wp_send_json_error( $errors );
		}

		update_option( 'oem_currency', $currency );
		update_option( 'oem_registration_page_url', $registration_page_url );
		update_option( 'oem_exam_page_url', $exam_page_url );
		update_option( 'enable_photo', $enable_photo );

		$message = esc_html__( 'Settings saved.', 'online-exam-management' );

		wp_send_json_success( array( 'message' => $message ) );
	}

	public static function save_registration() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		OEM_Helper::check_nonce( 'save-registration-settings' );

		$errors = array();

		$reg_no_prefix = isset( $_POST['reg_no_prefix'] ) ? sanitize_text_field( $_POST['reg_no_prefix'] ) : '';
		$reg_no_base   = isset( $_POST['reg_no_base'] ) ? absint( $_POST['reg_no_base'] ) : 0;

		if ( count( $errors ) > 0 ) {
			wp_send_json_error( $errors );
		}

		$registration_data = array(
			'reg_no_prefix' => $reg_no_prefix,
			'reg_no_base'   => $reg_no_base,
		);

		update_option( 'oem_registration', $registration_data );

		$message = esc_html__( 'Settings saved.', 'online-exam-management' );

		wp_send_json_success( array( 'message' => $message ) );
	}

	public static function save_datetime() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		OEM_Helper::check_nonce( 'save-datetime-settings' );

		$errors = array();

		$at_format = isset( $_POST['at_format'] ) ? sanitize_text_field( $_POST['at_format'] ) : '';

		if ( ! in_array( $at_format, OEM_Helper::at_formats() ) ) {
			$errors['at_format'] = esc_html__( 'Please select valid date / time format.', 'online-exam-management' );
		}

		if ( count( $errors ) > 0 ) {
			wp_send_json_error( $errors );
		}

		update_option( 'oem_at_format', $at_format );

		$message = esc_html__( 'Settings saved.', 'online-exam-management' );

		wp_send_json_success( array( 'message' => $message ) );
	}

	public static function save_payment_methods() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		OEM_Helper::check_nonce( 'save-payment-methods-settings' );

		$errors = array();

		$razorpay_enable = isset( $_POST['razorpay_enable'] ) ? (bool) ( $_POST['razorpay_enable'] ) : 0;
		$razorpay_key    = isset( $_POST['razorpay_key'] ) ? sanitize_text_field( $_POST['razorpay_key'] ) : '';
		$razorpay_secret = isset( $_POST['razorpay_secret'] ) ? sanitize_text_field( $_POST['razorpay_secret'] ) : '';

		$stripe_enable = isset( $_POST['stripe_enable'] ) ? (bool) ( $_POST['stripe_enable'] ) : 0;
		$stripe_key    = isset( $_POST['stripe_key'] ) ? sanitize_text_field( $_POST['stripe_key'] ) : '';
		$stripe_secret = isset( $_POST['stripe_secret'] ) ? sanitize_text_field( $_POST['stripe_secret'] ) : '';

		if ( count( $errors ) > 0 ) {
			wp_send_json_error( $errors );
		}

		$razorpay_data = array(
			'enable' => $razorpay_enable,
			'key'    => $razorpay_key,
			'secret' => $razorpay_secret,
		);

		$stripe_data = array(
			'enable' => $stripe_enable,
			'key'    => $stripe_key,
			'secret' => $stripe_secret,
		);

		update_option( 'oem_razorpay', $razorpay_data );
		update_option( 'oem_stripe', $stripe_data );

		$message = esc_html__( 'Settings saved.', 'online-exam-management' );

		wp_send_json_success( array( 'message' => $message ) );
	}

	public static function save_email_settings() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		OEM_Helper::check_nonce( 'save-email-settings' );
		// echo '<pre>' . var_dump($_POST) . '</pre>';
		$errors = array();

		$email_type            = isset( $_POST['email_type'] ) ? sanitize_text_field( $_POST['email_type'] ) : '';
		$email_from_name       = isset( $_POST['email_from_name'] ) ? sanitize_text_field( $_POST['email_from_name'] ) : '';
		$email_smtp_host       = isset( $_POST['email_smtp_host'] ) ? sanitize_text_field( $_POST['email_smtp_host'] ) : '';
		$email_smtp_username   = isset( $_POST['email_smtp_username'] ) ? sanitize_text_field( $_POST['email_smtp_username'] ) : '';
		$email_smtp_password   = isset( $_POST['email_smtp_password'] ) ? sanitize_text_field( $_POST['email_smtp_password'] ) : '';
		$email_smtp_encryption = isset( $_POST['email_smtp_encryption'] ) ? sanitize_text_field( $_POST['email_smtp_encryption'] ) : '';
		$email_smtp_port       = isset( $_POST['email_smtp_port'] ) ? sanitize_text_field( $_POST['email_smtp_port'] ) : '';

		if ( count( $errors ) > 0 ) {
			wp_send_json_error( $errors );
		}

		$email_settings_data = array(
			'email_type'            => $email_type,
			'email_from_name'       => $email_from_name,
			'email_smtp_host'       => $email_smtp_host,
			'email_smtp_username'   => $email_smtp_username,
			'email_smtp_password'   => $email_smtp_password,
			'email_smtp_encryption' => $email_smtp_encryption,
			'email_smtp_port'       => $email_smtp_port,
		);

		update_option( 'oem_email_settings_data', $email_settings_data );

		$message = esc_html__( 'Settings saved.', 'online-exam-management' );

		wp_send_json_success( array( 'message' => $message ) );
	}

	public static function save_email_templates() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		OEM_Helper::check_nonce( 'save-email-template' );

		$errors = array();

		// Registration
		$registration_template_enable = isset( $_POST['registration_template'] ) ? sanitize_text_field( $_POST['registration_template'] ) : '';
		$registration_subject         = isset( $_POST['registration_subject'] ) ? sanitize_text_field( $_POST['registration_subject'] ) : '';
		$email_registration_body      = isset( $_POST['email_registration_body'] ) ? sanitize_text_field( $_POST['email_registration_body'] ) : '';
		
		// Result
		$result_template_enable = isset( $_POST['result_template'] ) ? sanitize_text_field( $_POST['result_template'] ) : '';
		$result_subject         = isset( $_POST['result_subject'] ) ? sanitize_text_field( $_POST['result_subject'] ) : '';
		$email_result_body      = isset( $_POST['email_result_body'] ) ? sanitize_text_field( $_POST['email_result_body'] ) : '';
		

		if ( count( $errors ) > 0 ) {
			wp_send_json_error( $errors );
		}

		$email_settings_data = array(
			'registration_template'   => $registration_template_enable,
			'registration_subject'    => $registration_subject,
			'email_registration_body' => $email_registration_body,

			'result_template'   => $result_template_enable,
			'result_subject'    => $result_subject,
			'email_result_body' => $email_result_body,
		);

		update_option( 'oem_email_template_data', $email_settings_data );

		$message = esc_html__( 'Settings saved.', 'online-exam-management' );

		wp_send_json_success( array( 'message' => $message ) );
	}

	public static function send_test_email() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		OEM_Helper::check_nonce( 'send-test-email' );

		$errors = array();

		
		$template = isset($_POST['template']) ? sanitize_text_field($_POST['template']) : '';
		$email_to = isset($_POST['to']) ? sanitize_text_field($_POST['to']) : '';

		if (empty($email_to)) {
			wp_send_json_error(esc_html__('Please provide an email.', 'online-exam-management'));
		}

		if (!filter_var($email_to, FILTER_VALIDATE_EMAIL)) {
			wp_send_json_error(esc_html__('Please provide a valid email.', 'online-exam-management'));
		}		

		$settings    = OEM_Helper::get_email_template();

		if ($settings['registration_template']) {
			
			$subject = $settings['registration_subject'];
			$body    = $settings['email_registration_body'];
			$sent = OEM_Helper::send_email($email_to, $subject, $body);		
		}
	
		
		$sent = esc_html__( 'Email Sent.', 'online-exam-management' );

		wp_send_json_success( array( 'message' => $sent ) );
	}

	public static function save_payment_receipt() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		OEM_Helper::check_nonce( 'save-payment-receipt-settings' );

		$errors = array();

		$receipt_no_prefix = isset( $_POST['payment_receipt_no_prefix'] ) ? sanitize_text_field( $_POST['payment_receipt_no_prefix'] ) : '';
		$receipt_no_base   = isset( $_POST['payment_receipt_no_base'] ) ? absint( $_POST['payment_receipt_no_base'] ) : 0;

		if ( count( $errors ) > 0 ) {
			wp_send_json_error( $errors );
		}

		$payment_receipt_data = array(
			'receipt_no_prefix' => $receipt_no_prefix,
			'receipt_no_base'   => $receipt_no_base,
		);

		update_option( 'oem_payment_receipt', $payment_receipt_data );

		$message = esc_html__( 'Settings saved.', 'online-exam-management' );

		wp_send_json_success( array( 'message' => $message ) );
	}

	public static function reset_plugin() {

		if ( ! wp_verify_nonce( $_POST['reset-plugin'], 'reset-plugin' ) ) {
			die();
		}

		try {
			ob_start();
			global $wpdb;

			$wpdb->query( 'BEGIN;' );

			// Drop all tables and delete options.
			OEM_Database::remove_data();

			// Run activation function.
			OEM_Database::activation();

			$buffer = ob_get_clean();
			if ( ! empty( $buffer ) ) {
				throw new Exception( $buffer );
			}

			$wpdb->query( 'COMMIT;' );

			$message = esc_html__( 'Plugin has been reset to its initial state.', 'online-exam-management' );
			wp_send_json_success( array( 'message' => $message, 'reload' => true ) );

		} catch ( Exception $exception ) {
			$wpdb->query( 'ROLLBACK;' );
			wp_send_json_error( $exception->getMessage() );
		}

		wp_send_json_error( esc_html__( 'Unable to reset the plugin.', 'online-exam-management' ) );
	}
}
