<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Exam.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Result.php';

class OEM_Result {
	public static function fetch_exams_results() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		global $wpdb;

		$page_url = OEM_Helper::get_page_url('results');

		$query = OEM_M_Exam::fetch_results_query();

		$query_filter = $query;

		// Grouping.
		$group_by = ' ' . OEM_M_Exam::fetch_query_group_by();

		$query        .= $group_by;
		$query_filter .= $group_by;

		// Searching.
		$condition = '';
		if ( isset( $_POST['search']['value'] ) ) {
			$search_value = sanitize_text_field( $_POST['search']['value'] );
			if ( '' !== $search_value ) {
				$condition .= '' .
				'(ex.exam_title LIKE "%' . $search_value . '%") OR ' .
				'(ex.exam_code LIKE "%' . $search_value . '%") OR ' .
				'(ex.duration LIKE "%' . $search_value . '%")';

				$date_filter = OEM_Helper::filter_by_date( $search_value );

				$exam_at        = $date_filter['date'];
				$format_exam_at = $date_filter['format'];

				if ( $exam_at && ! empty( $format_exam_at ) ) {
					$exam_at = $exam_at->format( $format_exam_at );
					$exam_at = ' OR (ex.exam_at LIKE "%' . $exam_at . '%")';

					$condition .= $exam_at;
				}

				$query_filter .= ( ' HAVING ' . $condition );
			}
		}

		// Ordering.
		$columns = array( 'ex.exam_title', 'ex.exam_code', 'ex.exam_at', 'ex.duration' );
		if ( isset( $_POST['order'] ) && isset( $columns[ $_POST['order']['0']['column'] ] ) ) {
			$order_by  = sanitize_text_field( $columns[ $_POST['order']['0']['column'] ] );
			$order_dir = sanitize_text_field( $_POST['order']['0']['dir'] );

			$query_filter .= ' ORDER BY ' . $order_by . ' ' . $order_dir;
		} else {
			$query_filter .= ' ORDER BY ex.ID DESC';
		}

		// Limiting.
		$limit = '';
		if ( -1 != $_POST['length'] ) {
			$start  = absint( $_POST['start'] );
			$length = absint( $_POST['length'] );

			$limit  = ' LIMIT ' . $start . ', ' . $length;
		}

		// Total query.
		$rows_query = OEM_M_Exam::fetch_results_query_count();

		// Total rows count.
		$total_rows_count = $wpdb->get_var( $rows_query );

		// Filtered rows count.
		if ( $condition ) {
			$filter_rows_count = $wpdb->get_var( $rows_query . ' WHERE (' . $condition . ')' );
		} else {
			$filter_rows_count = $total_rows_count;
		}

		// Filtered limit rows.
		$filter_rows_limit = $wpdb->get_results( $query_filter . $limit );

		$data = array();
		if ( count( $filter_rows_limit ) ) {
			foreach ( $filter_rows_limit as $row ) {
				// Table columns.
				$data[] = array(
					esc_html( OEM_Helper::stripslashes( $row->exam_title ) ),
					esc_html( $row->exam_code ),
					esc_html( OEM_Helper::get_at_text( $row->exam_at ) ),
					absint( $row->duration ),
					// OEM_Helper::get_yes_no_text( $row->show_result_on_completion, true ),
					OEM_Helper::get_yes_no_text( $row->show_result_in_form, true ),
					OEM_Helper::get_yes_no_text($row->show_result_in_form, true),
					'<a class="btn oem-btn-xs oem-btn-primary oem-font-bold" href="' . esc_url( $page_url . "&action=list&exam_id=" . $row->ID ) . '">' . esc_html__( 'Manage Results', 'online-exam-management' ) . '</a>'
				);
			}
		}

		$output = array(
			'draw'            => absint( $_POST['draw'] ),
			'recordsTotal'    => $total_rows_count,
			'recordsFiltered' => $filter_rows_count,
			'data'            => $data,
		);

		echo json_encode( $output );
		die;
	}

	public static function fetch_students_results() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		$exam_id = isset( $_POST['exam_id'] ) ? absint( $_POST['exam_id'] ) : 0;

		global $wpdb;

		$page_url = OEM_Helper::get_page_url('results');

		$query = OEM_M_Student::fetch_query( $exam_id );

		$query_filter = $query;

		// Grouping.
		$group_by = ' ' . OEM_M_Student::fetch_query_group_by();

		$query        .= $group_by;
		$query_filter .= $group_by;

		// Searching.
		$condition = '';
		if ( isset( $_POST['search']['value'] ) ) {
			$search_value = sanitize_text_field( $_POST['search']['value'] );
			if ( '' !== $search_value ) {
				$condition .= '' .
				'(s.name LIKE "%' . $search_value . '%") OR ' .
				'(s.roll_number LIKE "%' . $search_value . '%") OR ' .
				'(s.class LIKE "%' . $search_value . '%") OR ' .
				'(s.section LIKE "%' . $search_value . '%") OR ' .
				'(s.phone LIKE "%' . $search_value . '%")';

				$query_filter .= ( ' HAVING ' . $condition );
			}
		}

		// Ordering.
		$columns = array( 's.name', 's.roll_number', 's.class', 's.section', 's.phone' );
		if ( isset( $_POST['order'] ) && isset( $columns[ $_POST['order']['0']['column'] ] ) ) {
			$order_by  = sanitize_text_field( $columns[ $_POST['order']['0']['column'] ] );
			$order_dir = sanitize_text_field( $_POST['order']['0']['dir'] );

			$query_filter .= ' ORDER BY ' . $order_by . ' ' . $order_dir;
		} else {
			$query_filter .= ' ORDER BY s.roll_number ASC';
		}

		// Limiting.
		$limit = '';
		if ( -1 != $_POST['length'] ) {
			$start  = absint( $_POST['start'] );
			$length = absint( $_POST['length'] );

			$limit  = ' LIMIT ' . $start . ', ' . $length;
		}

		// Total query.
		$rows_query = OEM_M_Student::fetch_query_count( $exam_id );

		// Total rows count.
		$total_rows_count = $wpdb->get_var( $rows_query );

		// Filtered rows count.
		if ( $condition ) {
			$filter_rows_count = $wpdb->get_var( $rows_query . ' AND (' . $condition . ')' );
		} else {
			$filter_rows_count = $total_rows_count;
		}

		// Filtered limit rows.
		$filter_rows_limit = $wpdb->get_results( $query_filter . $limit );
		
		$data = array();
		if ( count( $filter_rows_limit ) ) {
			foreach ( $filter_rows_limit as $row ) {
				$student_id = intval($row->ID);
				// var_dump($exam_id, $student_id);
				// die;
				// Total questions attempted by the student in this exam.
				$questions_attempted_count = OEM_M_Result::get_questions_attempted_count( $student_id, $exam_id );

				// Subject marks status.
				$subjective_marks_status = OEM_M_Result::get_subjective_marks_status( $student_id, $exam_id );
				$obtained_marks_sum = OEM_M_Result::get_subjective_marks_obtained( $student_id, $exam_id );
				
				$maximum_marks_sum = OEM_M_Question::get_questions_maximum_marks_sum($exam_id);
				// require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_result_stats.php';

				// ----------------------Calculate the marks ---------------------------------
				// Total questions attempted by the student in this exam.
				$questions_attempted       = OEM_M_Result::get_questions_attempted( $student_id, $exam_id );
				$questions_attempted_count = count( $questions_attempted );
				// Correct options.
				$correct_options = OEM_M_Result::get_questions_attempted_correct_options( $student_id, $exam_id );

				// Student answers.
				$student_answers = OEM_M_Result::get_student_answers( $student_id, $exam_id );

				// Subjective responses.
				$subjective_responses = OEM_M_Result::get_subjective_marks_obtained( $student_id, $exam_id );

				$obtained_marks_sum      = 0;
				$correct_answers_count   = 0;
				$incorrect_answers_count = 0;

				foreach ( $questions_attempted as $question ) {
					$questions_maximum_marks  = $question->maximum_marks;
					$questions_negative_marks = $question->negative_marks;

					if ( 'subjective' === $question->type ) {
						// Get subjective obtained marks of this question.
						$student_subjective_response = '';
						foreach ( $subjective_responses as $subjective_response ) {
							if ( $question->ID === $subjective_response->question_id ) {
								$student_subjective_response = $subjective_response;
								break;
							}
						}

						if ( $student_subjective_response ) {
							$student_obtained_marks = OEM_Helper::sanitize_marks( $student_subjective_response->sbj_marks_obtained );
						} else {
							$student_obtained_marks = 0;
						}

						// Add subjective obtained marks if greater than 0.
						if ( $student_obtained_marks > 0 ) {
							$obtained_marks_sum += $student_obtained_marks;
							$correct_answers_count++;
						} else {
							$incorrect_answers_count++;
						}

					} else {
						// Get correct option(s) of this question.
						$question_correct_options = array_filter(
							$correct_options,
							function( $correct_option ) use ( $question ) {
								return $question->ID === $correct_option->question_id;
							}
						);
						// Get correct option_id(s) of this question.
						$question_correct_option_ids = array_map(
							function( $question_correct_option ) {
								return $question_correct_option->ID;
							},
							$question_correct_options
						);

						// Get student answer(s) of this question.
						$question_student_answers = array_filter(
							$student_answers,
							function( $student_answer ) use ( $question ) {
								return $question->ID === $student_answer->question_id;
							}
						);
						// Get student answer(s) option_id(s) of this question.
						$question_student_answers_option_ids = array_map(
							function( $question_student_answer ) {
								return $question_student_answer->option_id;
							},
							$question_student_answers
						);

						// Check if two arrays are equal.
						$same = ( count( $question_correct_option_ids ) === count( $question_student_answers_option_ids ) && ! array_diff( $question_correct_option_ids, $question_student_answers_option_ids ) );
						if ( $same ) {
							// Student's answer is correct.
							$obtained_marks_sum += $questions_maximum_marks;
							$correct_answers_count++;
						} else {
							// Student's answer is incorrect.
							$obtained_marks_sum -= $questions_negative_marks;
							$incorrect_answers_count++;
						}
					}
				}


				// Table columns.
				$marks_sum = $obtained_marks_sum ? OEM_Helper::get_percentage_text($maximum_marks_sum, $obtained_marks_sum) : '-';
				$obtained_marks_sum = $obtained_marks_sum ? $obtained_marks_sum : '-';
				
				$data[] = array(
					esc_html( OEM_Helper::stripslashes( $row->name ) ),
					esc_html( OEM_Helper::get_text( $row->roll_number ) ),
					esc_html( OEM_Helper::stripslashes( $row->class, '-' ) ),
					esc_html( OEM_Helper::stripslashes( $row->section, '-' ) ),
					// esc_html( OEM_Helper::get_text( $row->phone, '-' ) ),
					esc_html( $questions_attempted_count ),
					$maximum_marks_sum,
					$obtained_marks_sum,
					$marks_sum,
					$subjective_marks_status,
					'<a class="btn btn-sm oem-btn-primary oem-font-bold" href="' . esc_url( $page_url . "&action=edit&exam_id=" . $exam_id . '&student_id=' . $row->ID ) . '">' . esc_html__( 'View / Edit Result', 'online-exam-management' ) . '</a>'
				);
			}
		}

		$output = array(
			'draw'            => absint( $_POST['draw'] ),
			'recordsTotal'    => $total_rows_count,
			'recordsFiltered' => $filter_rows_count,
			'data'            => $data,
		);

		echo json_encode( $output );
		die;
	}

	public static function edit_subjective_obtained_marks() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		$student_id = isset( $_POST['student_id'] ) ? absint( $_POST['student_id'] ) : 0;
		$exam_id    = isset( $_POST['exam_id'] ) ? absint( $_POST['exam_id'] ) : 0;

		OEM_Helper::check_nonce( 'edit-subjective-obtained-marks-' . $student_id );

		try {
			ob_start();
			global $wpdb;

			$errors = array();

			// Checks if student exists in the exam.
			$student = OEM_M_Student::get_student( $student_id, $exam_id );
			if ( ! $student ) {
				throw new Exception( esc_html__( 'Student not found.', 'online-exam-management' ) );
			}

			$question_ids   = ( isset( $_POST['question'] ) && is_array( $_POST['question'] ) ) ? array_map( 'absint', $_POST['question'] ) : array();
			$obtained_marks = ( isset( $_POST['obtained_marks'] ) && is_array( $_POST['obtained_marks'] ) ) ? array_map( 'sanitize_text_field', $_POST['obtained_marks'] ) : array();

			$responses = array();
			foreach ( $question_ids as $question_id ) {
				$subjective_question = OEM_M_Result::get_subjective_question_attempted_with_response( $student_id, $exam_id, $question_id );
				if ( ! $subjective_question ) {
					throw new Exception( esc_html__( 'Question not found.', 'online-exam-management' ) );
				}

				$response_id = $subjective_question->response_id;
				if ( ! empty( $response_id ) ) {
					$response = array( 'response_id' => $response_id );

					if ( ! isset( $obtained_marks[ $question_id ] ) || ( '' === $obtained_marks[ $question_id ] ) ) {
						$sbj_marks_obtained = NULL;
					} else {
						$sbj_marks_obtained = OEM_Helper::sanitize_marks( $obtained_marks[ $question_id ] );

						if ( $sbj_marks_obtained > $subjective_question->maximum_marks ) {
							throw new Exception( esc_html__( "Obtained marks can't be greater than maximum marks.", 'online-exam-management' ) );
						}
					}

					$response['sbj_marks_obtained'] = $sbj_marks_obtained;

					array_push( $responses, $response );
				}
			}

			OEM_Helper::check_buffer();

		} catch ( Exception $exception ) {
			wp_send_json_error( $exception->getMessage() );
		}

		if ( count( $errors ) > 0 ) {
			wp_send_json_error( $errors );
		}

		try {
			$wpdb->query( 'BEGIN;' );

			// Update obtained marks for subjective questions.
			foreach ( $responses as $response ) {
				$data = array(
					'sbj_marks_obtained' => $response['sbj_marks_obtained']
				);

				$success = $wpdb->update( OEM_RESPONSES, $data, array( 'ID' => $response['response_id'] ) );

				if ( false === $success ) {
					throw new Exception( $wpdb->last_error );
				}
			}

			OEM_Helper::check_buffer();

			$wpdb->query( 'COMMIT;' );

			$message = esc_html__( 'Obtained marks saved successfully.', 'online-exam-management' );

			wp_send_json_success( array( 'message' => $message ) );
		} catch ( Exception $exception ) {
			$wpdb->query( 'ROLLBACK;' );
			wp_send_json_error( $exception->getMessage() );
		}
	}
}
