<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Record.php';

class OEM_Record {
	public static function save_record() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		$record_id = isset( $_POST['record_id'] ) ? absint( $_POST['record_id'] ) : 0;

		OEM_Helper::check_nonce( 'edit-record-' . $record_id );

		try {
			ob_start();
			global $wpdb;

			$errors = array();

			// Checks if record exists.
			$record = OEM_M_Record::find( $record_id );
			if ( ! $record ) {
				throw new Exception( esc_html__( 'Registration not found.', 'online-exam-management' ) );
			}

			// Student detail.
			$reg_number   = isset( $_POST['reg_number'] ) ? sanitize_text_field( $_POST['reg_number'] ) : '';
			$name         = isset( $_POST['name'] ) ? sanitize_text_field( $_POST['name'] ) : '';
			$roll_number  = isset( $_POST['roll_number'] ) ? sanitize_text_field( $_POST['roll_number'] ) : '';
			$phone        = isset( $_POST['phone'] ) ? sanitize_text_field( $_POST['phone'] ) : '';
			$address      = isset( $_POST['address'] ) ? sanitize_text_field( $_POST['address'] ) : '';
			$father_name  = isset( $_POST['father_name'] ) ? sanitize_text_field( $_POST['father_name'] ) : '';
			$father_phone = isset( $_POST['father_phone'] ) ? sanitize_text_field( $_POST['father_phone'] ) : '';
			$photo        = ( isset( $_FILES['photo'] ) && is_array( $_FILES['photo'] ) ) ? $_FILES['photo'] : NULL;

			// Login detail.
			$new_login_email   = isset( $_POST['new_login_email'] ) ? sanitize_text_field( $_POST['new_login_email'] ) : '';
			$new_password      = isset( $_POST['new_password'] ) ? sanitize_text_field( $_POST['new_password'] ) : '';

			// Student detail.
			if ( empty( $reg_number ) ) {
				$errors['reg_number'] = esc_html__( 'Please enter registration number.', 'online-exam-management' );
			} else {
				// Check if registration number already exists.
				$record_exists = OEM_M_Record::get_record_by_reg_number( $reg_number, $record_id );
				if ( $record_exists ) {
					$errors['reg_number'] = esc_html__( 'Registration number already exists.', 'online-exam-management' );
				}
			}

			if ( empty( $name ) ) {
				$errors['name'] = esc_html__( 'Please enter student name.', 'online-exam-management' );
			} elseif ( strlen( $name ) > 60 ) {
				$errors['name'] = esc_html__( 'Maximum length cannot exceed 60 characters.', 'online-exam-management' );
			}

			if ( ! empty( $phone ) && strlen( $phone ) > 40 ) {
				$errors['phone'] = esc_html__( 'Maximum length cannot exceed 40 characters.', 'online-exam-management' );
			}

			if ( ! empty( $father_name ) && strlen( $father_name ) > 60 ) {
				$errors['father_name'] = esc_html__( 'Maximum length cannot exceed 60 characters.', 'online-exam-management' );
			}

			if ( ! empty( $father_phone ) && strlen( $father_phone ) > 40 ) {
				$errors['father_phone'] = esc_html__( 'Maximum length cannot exceed 40 characters.', 'online-exam-management' );
			}

			if ( isset( $photo['tmp_name'] ) && ! empty( $photo['tmp_name'] ) ) {
				if ( ! OEM_Helper::is_valid_file( $photo, 'image' ) ) {
					$errors['photo'] = esc_html__( 'Please provide photo in JPG, JPEG or PNG format.', 'online-exam-management' );
				}
			}

			if ( count( $errors ) > 0 ) {
				wp_send_json_error( $errors );
			}

			OEM_Helper::check_buffer();

		} catch ( Exception $exception ) {
			wp_send_json_error( $exception->getMessage() );
		}

		try {
			$wpdb->query( 'BEGIN;' );

			$user_id = $record_id;

			// Update email and password of existing user.
			$user_data = array(
				'ID'         => $user_id,
				'user_email' => $new_login_email,
			);

			if ( ! empty( $new_password ) ) {
				$user_data['user_pass'] = $new_password;
			}

			$user_id = wp_update_user( $user_data );
			if ( is_wp_error( $user_id ) ) {
				throw new Exception( $user_id->get_error_message() );
			}

			OEM_M_Record::save(
				$user_id,
				array(
					'reg_number'   => $reg_number,
					'name'         => $name,
					'phone'        => $phone,
					'address'      => $address,
					'father_name'  => $father_name,
					'father_phone' => $father_phone,
				)
			);

			if ( ! empty( $photo ) ) {
				$photo = media_handle_upload( 'photo', 0 );
				if ( is_wp_error( $photo ) ) {
					throw new Exception( $photo->get_error_message() );
				}
				update_user_meta( $user_id, 'oem_photo_id', $photo );
			}

			OEM_Helper::check_buffer();

			if ( false === $success ) {
				throw new Exception( $wpdb->last_error );
			}

			$wpdb->query( 'COMMIT;' );

			$message = esc_html__( 'Registration updated successfully.', 'online-exam-management' );

			wp_send_json_success( array( 'message' => $message ) );
		} catch ( Exception $exception ) {
			$wpdb->query( 'ROLLBACK;' );
			wp_send_json_error( $exception->getMessage() );
		}
	}

	public static function delete_record() {
		// OEM_Helper::check_demo_mode();

		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		try {
			ob_start();
			global $wpdb;

			$record_id = isset( $_POST['record_id'] ) ? absint( $_POST['record_id'] ) : 0;
			

			OEM_Helper::check_nonce( 'delete-record-' . $record_id );

			// Checks if record exists.
			$record = OEM_M_Record::find( $record_id );
			if ( ! $record ) {
				throw new Exception( esc_html__( 'Registration not found.', 'online-exam-management' ) );
			}

			if ( user_can( $record_id, OEM_ADMIN_CAPABILITY ) ) {
				throw new Exception( esc_html__( 'This registration belongs to the admin user.', 'online-exam-management' ) );
			}

			OEM_Helper::check_buffer();

		} catch ( Exception $exception ) {
			wp_send_json_error( $exception->getMessage() );
		}

		try {
			$wpdb->query( 'BEGIN;' );

			OEM_M_Record::delete( $record_id );

			$message = esc_html__( 'Registration deleted successfully.', 'online-exam-management' );

			OEM_Helper::check_buffer();

			if ( false === $success ) {
				throw new Exception( $wpdb->last_error );
			}

			$wpdb->query( 'COMMIT;' );

			wp_send_json_success( array( 'message' => $message ) );
		} catch ( Exception $exception ) {
			$wpdb->query( 'ROLLBACK;' );
			wp_send_json_error( $exception->getMessage() );
		}
	}
}
